/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ProactiveRefreshTokenRenewal;
import software.amazon.awssdk.services.iotmanagedintegrations.model.TokenEndpointAuthenticationScheme;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OAuthConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OAuthConfig> {
    private static final SdkField<String> AUTH_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("authUrl").getter(OAuthConfig.getter(OAuthConfig::authUrl)).setter(OAuthConfig.setter(Builder::authUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authUrl").build()}).build();
    private static final SdkField<String> TOKEN_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tokenUrl").getter(OAuthConfig.getter(OAuthConfig::tokenUrl)).setter(OAuthConfig.setter(Builder::tokenUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tokenUrl").build()}).build();
    private static final SdkField<String> SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("scope").getter(OAuthConfig.getter(OAuthConfig::scope)).setter(OAuthConfig.setter(Builder::scope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scope").build()}).build();
    private static final SdkField<String> TOKEN_ENDPOINT_AUTHENTICATION_SCHEME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tokenEndpointAuthenticationScheme").getter(OAuthConfig.getter(OAuthConfig::tokenEndpointAuthenticationSchemeAsString)).setter(OAuthConfig.setter(Builder::tokenEndpointAuthenticationScheme)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tokenEndpointAuthenticationScheme").build()}).build();
    private static final SdkField<String> O_AUTH_COMPLETE_REDIRECT_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("oAuthCompleteRedirectUrl").getter(OAuthConfig.getter(OAuthConfig::oAuthCompleteRedirectUrl)).setter(OAuthConfig.setter(Builder::oAuthCompleteRedirectUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("oAuthCompleteRedirectUrl").build()}).build();
    private static final SdkField<ProactiveRefreshTokenRenewal> PROACTIVE_REFRESH_TOKEN_RENEWAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("proactiveRefreshTokenRenewal").getter(OAuthConfig.getter(OAuthConfig::proactiveRefreshTokenRenewal)).setter(OAuthConfig.setter(Builder::proactiveRefreshTokenRenewal)).constructor(ProactiveRefreshTokenRenewal::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("proactiveRefreshTokenRenewal").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTH_URL_FIELD, TOKEN_URL_FIELD, SCOPE_FIELD, TOKEN_ENDPOINT_AUTHENTICATION_SCHEME_FIELD, O_AUTH_COMPLETE_REDIRECT_URL_FIELD, PROACTIVE_REFRESH_TOKEN_RENEWAL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = OAuthConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String authUrl;
    private final String tokenUrl;
    private final String scope;
    private final String tokenEndpointAuthenticationScheme;
    private final String oAuthCompleteRedirectUrl;
    private final ProactiveRefreshTokenRenewal proactiveRefreshTokenRenewal;

    private OAuthConfig(BuilderImpl builder) {
        this.authUrl = builder.authUrl;
        this.tokenUrl = builder.tokenUrl;
        this.scope = builder.scope;
        this.tokenEndpointAuthenticationScheme = builder.tokenEndpointAuthenticationScheme;
        this.oAuthCompleteRedirectUrl = builder.oAuthCompleteRedirectUrl;
        this.proactiveRefreshTokenRenewal = builder.proactiveRefreshTokenRenewal;
    }

    public final String authUrl() {
        return this.authUrl;
    }

    public final String tokenUrl() {
        return this.tokenUrl;
    }

    public final String scope() {
        return this.scope;
    }

    public final TokenEndpointAuthenticationScheme tokenEndpointAuthenticationScheme() {
        return TokenEndpointAuthenticationScheme.fromValue(this.tokenEndpointAuthenticationScheme);
    }

    public final String tokenEndpointAuthenticationSchemeAsString() {
        return this.tokenEndpointAuthenticationScheme;
    }

    public final String oAuthCompleteRedirectUrl() {
        return this.oAuthCompleteRedirectUrl;
    }

    public final ProactiveRefreshTokenRenewal proactiveRefreshTokenRenewal() {
        return this.proactiveRefreshTokenRenewal;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.authUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.tokenUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.scope());
        hashCode = 31 * hashCode + Objects.hashCode(this.tokenEndpointAuthenticationSchemeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.oAuthCompleteRedirectUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.proactiveRefreshTokenRenewal());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OAuthConfig)) {
            return false;
        }
        OAuthConfig other = (OAuthConfig)obj;
        return Objects.equals(this.authUrl(), other.authUrl()) && Objects.equals(this.tokenUrl(), other.tokenUrl()) && Objects.equals(this.scope(), other.scope()) && Objects.equals(this.tokenEndpointAuthenticationSchemeAsString(), other.tokenEndpointAuthenticationSchemeAsString()) && Objects.equals(this.oAuthCompleteRedirectUrl(), other.oAuthCompleteRedirectUrl()) && Objects.equals(this.proactiveRefreshTokenRenewal(), other.proactiveRefreshTokenRenewal());
    }

    public final String toString() {
        return ToString.builder((String)"OAuthConfig").add("AuthUrl", (Object)this.authUrl()).add("TokenUrl", (Object)this.tokenUrl()).add("Scope", (Object)this.scope()).add("TokenEndpointAuthenticationScheme", (Object)this.tokenEndpointAuthenticationSchemeAsString()).add("OAuthCompleteRedirectUrl", (Object)this.oAuthCompleteRedirectUrl()).add("ProactiveRefreshTokenRenewal", (Object)this.proactiveRefreshTokenRenewal()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "authUrl": {
                return Optional.ofNullable(clazz.cast(this.authUrl()));
            }
            case "tokenUrl": {
                return Optional.ofNullable(clazz.cast(this.tokenUrl()));
            }
            case "scope": {
                return Optional.ofNullable(clazz.cast(this.scope()));
            }
            case "tokenEndpointAuthenticationScheme": {
                return Optional.ofNullable(clazz.cast(this.tokenEndpointAuthenticationSchemeAsString()));
            }
            case "oAuthCompleteRedirectUrl": {
                return Optional.ofNullable(clazz.cast(this.oAuthCompleteRedirectUrl()));
            }
            case "proactiveRefreshTokenRenewal": {
                return Optional.ofNullable(clazz.cast(this.proactiveRefreshTokenRenewal()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("authUrl", AUTH_URL_FIELD);
        map.put("tokenUrl", TOKEN_URL_FIELD);
        map.put("scope", SCOPE_FIELD);
        map.put("tokenEndpointAuthenticationScheme", TOKEN_ENDPOINT_AUTHENTICATION_SCHEME_FIELD);
        map.put("oAuthCompleteRedirectUrl", O_AUTH_COMPLETE_REDIRECT_URL_FIELD);
        map.put("proactiveRefreshTokenRenewal", PROACTIVE_REFRESH_TOKEN_RENEWAL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OAuthConfig, T> g) {
        return obj -> g.apply((OAuthConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String authUrl;
        private String tokenUrl;
        private String scope;
        private String tokenEndpointAuthenticationScheme;
        private String oAuthCompleteRedirectUrl;
        private ProactiveRefreshTokenRenewal proactiveRefreshTokenRenewal;

        private BuilderImpl() {
        }

        private BuilderImpl(OAuthConfig model) {
            this.authUrl(model.authUrl);
            this.tokenUrl(model.tokenUrl);
            this.scope(model.scope);
            this.tokenEndpointAuthenticationScheme(model.tokenEndpointAuthenticationScheme);
            this.oAuthCompleteRedirectUrl(model.oAuthCompleteRedirectUrl);
            this.proactiveRefreshTokenRenewal(model.proactiveRefreshTokenRenewal);
        }

        public final String getAuthUrl() {
            return this.authUrl;
        }

        public final void setAuthUrl(String authUrl) {
            this.authUrl = authUrl;
        }

        @Override
        public final Builder authUrl(String authUrl) {
            this.authUrl = authUrl;
            return this;
        }

        public final String getTokenUrl() {
            return this.tokenUrl;
        }

        public final void setTokenUrl(String tokenUrl) {
            this.tokenUrl = tokenUrl;
        }

        @Override
        public final Builder tokenUrl(String tokenUrl) {
            this.tokenUrl = tokenUrl;
            return this;
        }

        public final String getScope() {
            return this.scope;
        }

        public final void setScope(String scope) {
            this.scope = scope;
        }

        @Override
        public final Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        public final String getTokenEndpointAuthenticationScheme() {
            return this.tokenEndpointAuthenticationScheme;
        }

        public final void setTokenEndpointAuthenticationScheme(String tokenEndpointAuthenticationScheme) {
            this.tokenEndpointAuthenticationScheme = tokenEndpointAuthenticationScheme;
        }

        @Override
        public final Builder tokenEndpointAuthenticationScheme(String tokenEndpointAuthenticationScheme) {
            this.tokenEndpointAuthenticationScheme = tokenEndpointAuthenticationScheme;
            return this;
        }

        @Override
        public final Builder tokenEndpointAuthenticationScheme(TokenEndpointAuthenticationScheme tokenEndpointAuthenticationScheme) {
            this.tokenEndpointAuthenticationScheme(tokenEndpointAuthenticationScheme == null ? null : tokenEndpointAuthenticationScheme.toString());
            return this;
        }

        public final String getOAuthCompleteRedirectUrl() {
            return this.oAuthCompleteRedirectUrl;
        }

        public final void setOAuthCompleteRedirectUrl(String oAuthCompleteRedirectUrl) {
            this.oAuthCompleteRedirectUrl = oAuthCompleteRedirectUrl;
        }

        @Override
        public final Builder oAuthCompleteRedirectUrl(String oAuthCompleteRedirectUrl) {
            this.oAuthCompleteRedirectUrl = oAuthCompleteRedirectUrl;
            return this;
        }

        public final ProactiveRefreshTokenRenewal.Builder getProactiveRefreshTokenRenewal() {
            return this.proactiveRefreshTokenRenewal != null ? this.proactiveRefreshTokenRenewal.toBuilder() : null;
        }

        public final void setProactiveRefreshTokenRenewal(ProactiveRefreshTokenRenewal.BuilderImpl proactiveRefreshTokenRenewal) {
            this.proactiveRefreshTokenRenewal = proactiveRefreshTokenRenewal != null ? proactiveRefreshTokenRenewal.build() : null;
        }

        @Override
        public final Builder proactiveRefreshTokenRenewal(ProactiveRefreshTokenRenewal proactiveRefreshTokenRenewal) {
            this.proactiveRefreshTokenRenewal = proactiveRefreshTokenRenewal;
            return this;
        }

        public OAuthConfig build() {
            return new OAuthConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OAuthConfig> {
        public Builder authUrl(String var1);

        public Builder tokenUrl(String var1);

        public Builder scope(String var1);

        public Builder tokenEndpointAuthenticationScheme(String var1);

        public Builder tokenEndpointAuthenticationScheme(TokenEndpointAuthenticationScheme var1);

        public Builder oAuthCompleteRedirectUrl(String var1);

        public Builder proactiveRefreshTokenRenewal(ProactiveRefreshTokenRenewal var1);

        default public Builder proactiveRefreshTokenRenewal(Consumer<ProactiveRefreshTokenRenewal.Builder> proactiveRefreshTokenRenewal) {
            return this.proactiveRefreshTokenRenewal((ProactiveRefreshTokenRenewal)((ProactiveRefreshTokenRenewal.Builder)ProactiveRefreshTokenRenewal.builder().applyMutation(proactiveRefreshTokenRenewal)).build());
        }
    }
}

