/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotmanagedintegrations.model.IotManagedIntegrationsRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.SchemaVersionFormat;
import software.amazon.awssdk.services.iotmanagedintegrations.model.SchemaVersionType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSchemaVersionRequest
extends IotManagedIntegrationsRequest
implements ToCopyableBuilder<Builder, GetSchemaVersionRequest> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(GetSchemaVersionRequest.getter(GetSchemaVersionRequest::typeAsString)).setter(GetSchemaVersionRequest.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("Type").build()}).build();
    private static final SdkField<String> SCHEMA_VERSIONED_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SchemaVersionedId").getter(GetSchemaVersionRequest.getter(GetSchemaVersionRequest::schemaVersionedId)).setter(GetSchemaVersionRequest.setter(Builder::schemaVersionedId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("SchemaVersionedId").build()}).build();
    private static final SdkField<String> FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Format").getter(GetSchemaVersionRequest.getter(GetSchemaVersionRequest::formatAsString)).setter(GetSchemaVersionRequest.setter(Builder::format)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("Format").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, SCHEMA_VERSIONED_ID_FIELD, FORMAT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetSchemaVersionRequest.memberNameToFieldInitializer();
    private final String type;
    private final String schemaVersionedId;
    private final String format;

    private GetSchemaVersionRequest(BuilderImpl builder) {
        super(builder);
        this.type = builder.type;
        this.schemaVersionedId = builder.schemaVersionedId;
        this.format = builder.format;
    }

    public final SchemaVersionType type() {
        return SchemaVersionType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String schemaVersionedId() {
        return this.schemaVersionedId;
    }

    public final SchemaVersionFormat format() {
        return SchemaVersionFormat.fromValue(this.format);
    }

    public final String formatAsString() {
        return this.format;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaVersionedId());
        hashCode = 31 * hashCode + Objects.hashCode(this.formatAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSchemaVersionRequest)) {
            return false;
        }
        GetSchemaVersionRequest other = (GetSchemaVersionRequest)((Object)obj);
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.schemaVersionedId(), other.schemaVersionedId()) && Objects.equals(this.formatAsString(), other.formatAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetSchemaVersionRequest").add("Type", (Object)this.typeAsString()).add("SchemaVersionedId", (Object)this.schemaVersionedId()).add("Format", (Object)this.formatAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "SchemaVersionedId": {
                return Optional.ofNullable(clazz.cast(this.schemaVersionedId()));
            }
            case "Format": {
                return Optional.ofNullable(clazz.cast(this.formatAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Type", TYPE_FIELD);
        map.put("SchemaVersionedId", SCHEMA_VERSIONED_ID_FIELD);
        map.put("Format", FORMAT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetSchemaVersionRequest, T> g) {
        return obj -> g.apply((GetSchemaVersionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotManagedIntegrationsRequest.BuilderImpl
    implements Builder {
        private String type;
        private String schemaVersionedId;
        private String format;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSchemaVersionRequest model) {
            super(model);
            this.type(model.type);
            this.schemaVersionedId(model.schemaVersionedId);
            this.format(model.format);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(SchemaVersionType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getSchemaVersionedId() {
            return this.schemaVersionedId;
        }

        public final void setSchemaVersionedId(String schemaVersionedId) {
            this.schemaVersionedId = schemaVersionedId;
        }

        @Override
        public final Builder schemaVersionedId(String schemaVersionedId) {
            this.schemaVersionedId = schemaVersionedId;
            return this;
        }

        public final String getFormat() {
            return this.format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(SchemaVersionFormat format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetSchemaVersionRequest build() {
            return new GetSchemaVersionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IotManagedIntegrationsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetSchemaVersionRequest> {
        public Builder type(String var1);

        public Builder type(SchemaVersionType var1);

        public Builder schemaVersionedId(String var1);

        public Builder format(String var1);

        public Builder format(SchemaVersionFormat var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

