/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iotmanagedintegrations.model.IotManagedIntegrationsRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ProvisioningType;
import software.amazon.awssdk.services.iotmanagedintegrations.model.TagsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateProvisioningProfileRequest
extends IotManagedIntegrationsRequest
implements ToCopyableBuilder<Builder, CreateProvisioningProfileRequest> {
    private static final SdkField<String> PROVISIONING_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProvisioningType").getter(CreateProvisioningProfileRequest.getter(CreateProvisioningProfileRequest::provisioningTypeAsString)).setter(CreateProvisioningProfileRequest.setter(Builder::provisioningType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningType").build()}).build();
    private static final SdkField<String> CA_CERTIFICATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CaCertificate").getter(CreateProvisioningProfileRequest.getter(CreateProvisioningProfileRequest::caCertificate)).setter(CreateProvisioningProfileRequest.setter(Builder::caCertificate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CaCertificate").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateProvisioningProfileRequest.getter(CreateProvisioningProfileRequest::name)).setter(CreateProvisioningProfileRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateProvisioningProfileRequest.getter(CreateProvisioningProfileRequest::clientToken)).setter(CreateProvisioningProfileRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateProvisioningProfileRequest.getter(CreateProvisioningProfileRequest::tags)).setter(CreateProvisioningProfileRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROVISIONING_TYPE_FIELD, CA_CERTIFICATE_FIELD, NAME_FIELD, CLIENT_TOKEN_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateProvisioningProfileRequest.memberNameToFieldInitializer();
    private final String provisioningType;
    private final String caCertificate;
    private final String name;
    private final String clientToken;
    private final Map<String, String> tags;

    private CreateProvisioningProfileRequest(BuilderImpl builder) {
        super(builder);
        this.provisioningType = builder.provisioningType;
        this.caCertificate = builder.caCertificate;
        this.name = builder.name;
        this.clientToken = builder.clientToken;
        this.tags = builder.tags;
    }

    public final ProvisioningType provisioningType() {
        return ProvisioningType.fromValue(this.provisioningType);
    }

    public final String provisioningTypeAsString() {
        return this.provisioningType;
    }

    public final String caCertificate() {
        return this.caCertificate;
    }

    public final String name() {
        return this.name;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.provisioningTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.caCertificate());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateProvisioningProfileRequest)) {
            return false;
        }
        CreateProvisioningProfileRequest other = (CreateProvisioningProfileRequest)((Object)obj);
        return Objects.equals(this.provisioningTypeAsString(), other.provisioningTypeAsString()) && Objects.equals(this.caCertificate(), other.caCertificate()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.clientToken(), other.clientToken()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateProvisioningProfileRequest").add("ProvisioningType", (Object)this.provisioningTypeAsString()).add("CaCertificate", (Object)(this.caCertificate() == null ? null : "*** Sensitive Data Redacted ***")).add("Name", (Object)this.name()).add("ClientToken", (Object)this.clientToken()).add("Tags", (Object)(this.tags() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProvisioningType": {
                return Optional.ofNullable(clazz.cast(this.provisioningTypeAsString()));
            }
            case "CaCertificate": {
                return Optional.ofNullable(clazz.cast(this.caCertificate()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ProvisioningType", PROVISIONING_TYPE_FIELD);
        map.put("CaCertificate", CA_CERTIFICATE_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateProvisioningProfileRequest, T> g) {
        return obj -> g.apply((CreateProvisioningProfileRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotManagedIntegrationsRequest.BuilderImpl
    implements Builder {
        private String provisioningType;
        private String caCertificate;
        private String name;
        private String clientToken;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateProvisioningProfileRequest model) {
            super(model);
            this.provisioningType(model.provisioningType);
            this.caCertificate(model.caCertificate);
            this.name(model.name);
            this.clientToken(model.clientToken);
            this.tags(model.tags);
        }

        public final String getProvisioningType() {
            return this.provisioningType;
        }

        public final void setProvisioningType(String provisioningType) {
            this.provisioningType = provisioningType;
        }

        @Override
        public final Builder provisioningType(String provisioningType) {
            this.provisioningType = provisioningType;
            return this;
        }

        @Override
        public final Builder provisioningType(ProvisioningType provisioningType) {
            this.provisioningType(provisioningType == null ? null : provisioningType.toString());
            return this;
        }

        public final String getCaCertificate() {
            return this.caCertificate;
        }

        public final void setCaCertificate(String caCertificate) {
            this.caCertificate = caCertificate;
        }

        @Override
        public final Builder caCertificate(String caCertificate) {
            this.caCertificate = caCertificate;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateProvisioningProfileRequest build() {
            return new CreateProvisioningProfileRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IotManagedIntegrationsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateProvisioningProfileRequest> {
        public Builder provisioningType(String var1);

        public Builder provisioningType(ProvisioningType var1);

        public Builder caCertificate(String var1);

        public Builder name(String var1);

        public Builder clientToken(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

