/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotmanagedintegrations.model.AssociationState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AccountAssociationItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AccountAssociationItem> {
    private static final SdkField<String> ACCOUNT_ASSOCIATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountAssociationId").getter(AccountAssociationItem.getter(AccountAssociationItem::accountAssociationId)).setter(AccountAssociationItem.setter(Builder::accountAssociationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountAssociationId").build()}).build();
    private static final SdkField<String> ASSOCIATION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssociationState").getter(AccountAssociationItem.getter(AccountAssociationItem::associationStateAsString)).setter(AccountAssociationItem.setter(Builder::associationState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationState").build()}).build();
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorMessage").getter(AccountAssociationItem.getter(AccountAssociationItem::errorMessage)).setter(AccountAssociationItem.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()}).build();
    private static final SdkField<String> CONNECTOR_DESTINATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectorDestinationId").getter(AccountAssociationItem.getter(AccountAssociationItem::connectorDestinationId)).setter(AccountAssociationItem.setter(Builder::connectorDestinationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectorDestinationId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(AccountAssociationItem.getter(AccountAssociationItem::name)).setter(AccountAssociationItem.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(AccountAssociationItem.getter(AccountAssociationItem::description)).setter(AccountAssociationItem.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(AccountAssociationItem.getter(AccountAssociationItem::arn)).setter(AccountAssociationItem.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ASSOCIATION_ID_FIELD, ASSOCIATION_STATE_FIELD, ERROR_MESSAGE_FIELD, CONNECTOR_DESTINATION_ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AccountAssociationItem.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String accountAssociationId;
    private final String associationState;
    private final String errorMessage;
    private final String connectorDestinationId;
    private final String name;
    private final String description;
    private final String arn;

    private AccountAssociationItem(BuilderImpl builder) {
        this.accountAssociationId = builder.accountAssociationId;
        this.associationState = builder.associationState;
        this.errorMessage = builder.errorMessage;
        this.connectorDestinationId = builder.connectorDestinationId;
        this.name = builder.name;
        this.description = builder.description;
        this.arn = builder.arn;
    }

    public final String accountAssociationId() {
        return this.accountAssociationId;
    }

    public final AssociationState associationState() {
        return AssociationState.fromValue(this.associationState);
    }

    public final String associationStateAsString() {
        return this.associationState;
    }

    public final String errorMessage() {
        return this.errorMessage;
    }

    public final String connectorDestinationId() {
        return this.connectorDestinationId;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final String arn() {
        return this.arn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountAssociationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.associationStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorDestinationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountAssociationItem)) {
            return false;
        }
        AccountAssociationItem other = (AccountAssociationItem)obj;
        return Objects.equals(this.accountAssociationId(), other.accountAssociationId()) && Objects.equals(this.associationStateAsString(), other.associationStateAsString()) && Objects.equals(this.errorMessage(), other.errorMessage()) && Objects.equals(this.connectorDestinationId(), other.connectorDestinationId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.arn(), other.arn());
    }

    public final String toString() {
        return ToString.builder((String)"AccountAssociationItem").add("AccountAssociationId", (Object)this.accountAssociationId()).add("AssociationState", (Object)this.associationStateAsString()).add("ErrorMessage", (Object)this.errorMessage()).add("ConnectorDestinationId", (Object)this.connectorDestinationId()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Arn", (Object)this.arn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountAssociationId": {
                return Optional.ofNullable(clazz.cast(this.accountAssociationId()));
            }
            case "AssociationState": {
                return Optional.ofNullable(clazz.cast(this.associationStateAsString()));
            }
            case "ErrorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
            case "ConnectorDestinationId": {
                return Optional.ofNullable(clazz.cast(this.connectorDestinationId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("AccountAssociationId", ACCOUNT_ASSOCIATION_ID_FIELD);
        map.put("AssociationState", ASSOCIATION_STATE_FIELD);
        map.put("ErrorMessage", ERROR_MESSAGE_FIELD);
        map.put("ConnectorDestinationId", CONNECTOR_DESTINATION_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Arn", ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AccountAssociationItem, T> g) {
        return obj -> g.apply((AccountAssociationItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accountAssociationId;
        private String associationState;
        private String errorMessage;
        private String connectorDestinationId;
        private String name;
        private String description;
        private String arn;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountAssociationItem model) {
            this.accountAssociationId(model.accountAssociationId);
            this.associationState(model.associationState);
            this.errorMessage(model.errorMessage);
            this.connectorDestinationId(model.connectorDestinationId);
            this.name(model.name);
            this.description(model.description);
            this.arn(model.arn);
        }

        public final String getAccountAssociationId() {
            return this.accountAssociationId;
        }

        public final void setAccountAssociationId(String accountAssociationId) {
            this.accountAssociationId = accountAssociationId;
        }

        @Override
        public final Builder accountAssociationId(String accountAssociationId) {
            this.accountAssociationId = accountAssociationId;
            return this;
        }

        public final String getAssociationState() {
            return this.associationState;
        }

        public final void setAssociationState(String associationState) {
            this.associationState = associationState;
        }

        @Override
        public final Builder associationState(String associationState) {
            this.associationState = associationState;
            return this;
        }

        @Override
        public final Builder associationState(AssociationState associationState) {
            this.associationState(associationState == null ? null : associationState.toString());
            return this;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final String getConnectorDestinationId() {
            return this.connectorDestinationId;
        }

        public final void setConnectorDestinationId(String connectorDestinationId) {
            this.connectorDestinationId = connectorDestinationId;
        }

        @Override
        public final Builder connectorDestinationId(String connectorDestinationId) {
            this.connectorDestinationId = connectorDestinationId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public AccountAssociationItem build() {
            return new AccountAssociationItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AccountAssociationItem> {
        public Builder accountAssociationId(String var1);

        public Builder associationState(String var1);

        public Builder associationState(AssociationState var1);

        public Builder errorMessage(String var1);

        public Builder connectorDestinationId(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder arn(String var1);
    }
}

