/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotmanagedintegrations.model.AbortCriteriaAction;
import software.amazon.awssdk.services.iotmanagedintegrations.model.AbortCriteriaFailureType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AbortConfigCriteria
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AbortConfigCriteria> {
    private static final SdkField<String> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Action").getter(AbortConfigCriteria.getter(AbortConfigCriteria::actionAsString)).setter(AbortConfigCriteria.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()}).build();
    private static final SdkField<String> FAILURE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureType").getter(AbortConfigCriteria.getter(AbortConfigCriteria::failureTypeAsString)).setter(AbortConfigCriteria.setter(Builder::failureType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureType").build()}).build();
    private static final SdkField<Integer> MIN_NUMBER_OF_EXECUTED_THINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinNumberOfExecutedThings").getter(AbortConfigCriteria.getter(AbortConfigCriteria::minNumberOfExecutedThings)).setter(AbortConfigCriteria.setter(Builder::minNumberOfExecutedThings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinNumberOfExecutedThings").build()}).build();
    private static final SdkField<Double> THRESHOLD_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("ThresholdPercentage").getter(AbortConfigCriteria.getter(AbortConfigCriteria::thresholdPercentage)).setter(AbortConfigCriteria.setter(Builder::thresholdPercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThresholdPercentage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD, FAILURE_TYPE_FIELD, MIN_NUMBER_OF_EXECUTED_THINGS_FIELD, THRESHOLD_PERCENTAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AbortConfigCriteria.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String action;
    private final String failureType;
    private final Integer minNumberOfExecutedThings;
    private final Double thresholdPercentage;

    private AbortConfigCriteria(BuilderImpl builder) {
        this.action = builder.action;
        this.failureType = builder.failureType;
        this.minNumberOfExecutedThings = builder.minNumberOfExecutedThings;
        this.thresholdPercentage = builder.thresholdPercentage;
    }

    public final AbortCriteriaAction action() {
        return AbortCriteriaAction.fromValue(this.action);
    }

    public final String actionAsString() {
        return this.action;
    }

    public final AbortCriteriaFailureType failureType() {
        return AbortCriteriaFailureType.fromValue(this.failureType);
    }

    public final String failureTypeAsString() {
        return this.failureType;
    }

    public final Integer minNumberOfExecutedThings() {
        return this.minNumberOfExecutedThings;
    }

    public final Double thresholdPercentage() {
        return this.thresholdPercentage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.minNumberOfExecutedThings());
        hashCode = 31 * hashCode + Objects.hashCode(this.thresholdPercentage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AbortConfigCriteria)) {
            return false;
        }
        AbortConfigCriteria other = (AbortConfigCriteria)obj;
        return Objects.equals(this.actionAsString(), other.actionAsString()) && Objects.equals(this.failureTypeAsString(), other.failureTypeAsString()) && Objects.equals(this.minNumberOfExecutedThings(), other.minNumberOfExecutedThings()) && Objects.equals(this.thresholdPercentage(), other.thresholdPercentage());
    }

    public final String toString() {
        return ToString.builder((String)"AbortConfigCriteria").add("Action", (Object)this.actionAsString()).add("FailureType", (Object)this.failureTypeAsString()).add("MinNumberOfExecutedThings", (Object)this.minNumberOfExecutedThings()).add("ThresholdPercentage", (Object)this.thresholdPercentage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Action": {
                return Optional.ofNullable(clazz.cast(this.actionAsString()));
            }
            case "FailureType": {
                return Optional.ofNullable(clazz.cast(this.failureTypeAsString()));
            }
            case "MinNumberOfExecutedThings": {
                return Optional.ofNullable(clazz.cast(this.minNumberOfExecutedThings()));
            }
            case "ThresholdPercentage": {
                return Optional.ofNullable(clazz.cast(this.thresholdPercentage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Action", ACTION_FIELD);
        map.put("FailureType", FAILURE_TYPE_FIELD);
        map.put("MinNumberOfExecutedThings", MIN_NUMBER_OF_EXECUTED_THINGS_FIELD);
        map.put("ThresholdPercentage", THRESHOLD_PERCENTAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AbortConfigCriteria, T> g) {
        return obj -> g.apply((AbortConfigCriteria)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String action;
        private String failureType;
        private Integer minNumberOfExecutedThings;
        private Double thresholdPercentage;

        private BuilderImpl() {
        }

        private BuilderImpl(AbortConfigCriteria model) {
            this.action(model.action);
            this.failureType(model.failureType);
            this.minNumberOfExecutedThings(model.minNumberOfExecutedThings);
            this.thresholdPercentage(model.thresholdPercentage);
        }

        public final String getAction() {
            return this.action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(AbortCriteriaAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final String getFailureType() {
            return this.failureType;
        }

        public final void setFailureType(String failureType) {
            this.failureType = failureType;
        }

        @Override
        public final Builder failureType(String failureType) {
            this.failureType = failureType;
            return this;
        }

        @Override
        public final Builder failureType(AbortCriteriaFailureType failureType) {
            this.failureType(failureType == null ? null : failureType.toString());
            return this;
        }

        public final Integer getMinNumberOfExecutedThings() {
            return this.minNumberOfExecutedThings;
        }

        public final void setMinNumberOfExecutedThings(Integer minNumberOfExecutedThings) {
            this.minNumberOfExecutedThings = minNumberOfExecutedThings;
        }

        @Override
        public final Builder minNumberOfExecutedThings(Integer minNumberOfExecutedThings) {
            this.minNumberOfExecutedThings = minNumberOfExecutedThings;
            return this;
        }

        public final Double getThresholdPercentage() {
            return this.thresholdPercentage;
        }

        public final void setThresholdPercentage(Double thresholdPercentage) {
            this.thresholdPercentage = thresholdPercentage;
        }

        @Override
        public final Builder thresholdPercentage(Double thresholdPercentage) {
            this.thresholdPercentage = thresholdPercentage;
            return this;
        }

        public AbortConfigCriteria build() {
            return new AbortConfigCriteria(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AbortConfigCriteria> {
        public Builder action(String var1);

        public Builder action(AbortCriteriaAction var1);

        public Builder failureType(String var1);

        public Builder failureType(AbortCriteriaFailureType var1);

        public Builder minNumberOfExecutedThings(Integer var1);

        public Builder thresholdPercentage(Double var1);
    }
}

