/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotfleetwise.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotfleetwise.model.IoTFleetWiseRequest;
import software.amazon.awssdk.services.iotfleetwise.model.ListResponseScope;
import software.amazon.awssdk.services.iotfleetwise.model._attributeNamesListCopier;
import software.amazon.awssdk.services.iotfleetwise.model._attributeValuesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListVehiclesRequest
extends IoTFleetWiseRequest
implements ToCopyableBuilder<Builder, ListVehiclesRequest> {
    private static final SdkField<String> MODEL_MANIFEST_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("modelManifestArn").getter(ListVehiclesRequest.getter(ListVehiclesRequest::modelManifestArn)).setter(ListVehiclesRequest.setter(Builder::modelManifestArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelManifestArn").build()}).build();
    private static final SdkField<List<String>> ATTRIBUTE_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("attributeNames").getter(ListVehiclesRequest.getter(ListVehiclesRequest::attributeNames)).setter(ListVehiclesRequest.setter(Builder::attributeNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributeNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ATTRIBUTE_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("attributeValues").getter(ListVehiclesRequest.getter(ListVehiclesRequest::attributeValues)).setter(ListVehiclesRequest.setter(Builder::attributeValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributeValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListVehiclesRequest.getter(ListVehiclesRequest::nextToken)).setter(ListVehiclesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListVehiclesRequest.getter(ListVehiclesRequest::maxResults)).setter(ListVehiclesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<String> LIST_RESPONSE_SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("listResponseScope").getter(ListVehiclesRequest.getter(ListVehiclesRequest::listResponseScopeAsString)).setter(ListVehiclesRequest.setter(Builder::listResponseScope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("listResponseScope").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_MANIFEST_ARN_FIELD, ATTRIBUTE_NAMES_FIELD, ATTRIBUTE_VALUES_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, LIST_RESPONSE_SCOPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListVehiclesRequest.memberNameToFieldInitializer();
    private final String modelManifestArn;
    private final List<String> attributeNames;
    private final List<String> attributeValues;
    private final String nextToken;
    private final Integer maxResults;
    private final String listResponseScope;

    private ListVehiclesRequest(BuilderImpl builder) {
        super(builder);
        this.modelManifestArn = builder.modelManifestArn;
        this.attributeNames = builder.attributeNames;
        this.attributeValues = builder.attributeValues;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.listResponseScope = builder.listResponseScope;
    }

    public final String modelManifestArn() {
        return this.modelManifestArn;
    }

    public final boolean hasAttributeNames() {
        return this.attributeNames != null && !(this.attributeNames instanceof SdkAutoConstructList);
    }

    public final List<String> attributeNames() {
        return this.attributeNames;
    }

    public final boolean hasAttributeValues() {
        return this.attributeValues != null && !(this.attributeValues instanceof SdkAutoConstructList);
    }

    public final List<String> attributeValues() {
        return this.attributeValues;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final ListResponseScope listResponseScope() {
        return ListResponseScope.fromValue(this.listResponseScope);
    }

    public final String listResponseScopeAsString() {
        return this.listResponseScope;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.modelManifestArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributeNames() ? this.attributeNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributeValues() ? this.attributeValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.listResponseScopeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListVehiclesRequest)) {
            return false;
        }
        ListVehiclesRequest other = (ListVehiclesRequest)((Object)obj);
        return Objects.equals(this.modelManifestArn(), other.modelManifestArn()) && this.hasAttributeNames() == other.hasAttributeNames() && Objects.equals(this.attributeNames(), other.attributeNames()) && this.hasAttributeValues() == other.hasAttributeValues() && Objects.equals(this.attributeValues(), other.attributeValues()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.listResponseScopeAsString(), other.listResponseScopeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ListVehiclesRequest").add("ModelManifestArn", (Object)this.modelManifestArn()).add("AttributeNames", this.hasAttributeNames() ? this.attributeNames() : null).add("AttributeValues", this.hasAttributeValues() ? this.attributeValues() : null).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("ListResponseScope", (Object)this.listResponseScopeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "modelManifestArn": {
                return Optional.ofNullable(clazz.cast(this.modelManifestArn()));
            }
            case "attributeNames": {
                return Optional.ofNullable(clazz.cast(this.attributeNames()));
            }
            case "attributeValues": {
                return Optional.ofNullable(clazz.cast(this.attributeValues()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "listResponseScope": {
                return Optional.ofNullable(clazz.cast(this.listResponseScopeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("modelManifestArn", MODEL_MANIFEST_ARN_FIELD);
        map.put("attributeNames", ATTRIBUTE_NAMES_FIELD);
        map.put("attributeValues", ATTRIBUTE_VALUES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("listResponseScope", LIST_RESPONSE_SCOPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListVehiclesRequest, T> g) {
        return obj -> g.apply((ListVehiclesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTFleetWiseRequest.BuilderImpl
    implements Builder {
        private String modelManifestArn;
        private List<String> attributeNames = DefaultSdkAutoConstructList.getInstance();
        private List<String> attributeValues = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Integer maxResults;
        private String listResponseScope;

        private BuilderImpl() {
        }

        private BuilderImpl(ListVehiclesRequest model) {
            super(model);
            this.modelManifestArn(model.modelManifestArn);
            this.attributeNames(model.attributeNames);
            this.attributeValues(model.attributeValues);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.listResponseScope(model.listResponseScope);
        }

        public final String getModelManifestArn() {
            return this.modelManifestArn;
        }

        public final void setModelManifestArn(String modelManifestArn) {
            this.modelManifestArn = modelManifestArn;
        }

        @Override
        public final Builder modelManifestArn(String modelManifestArn) {
            this.modelManifestArn = modelManifestArn;
            return this;
        }

        public final Collection<String> getAttributeNames() {
            if (this.attributeNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.attributeNames;
        }

        public final void setAttributeNames(Collection<String> attributeNames) {
            this.attributeNames = _attributeNamesListCopier.copy(attributeNames);
        }

        @Override
        public final Builder attributeNames(Collection<String> attributeNames) {
            this.attributeNames = _attributeNamesListCopier.copy(attributeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeNames(String ... attributeNames) {
            this.attributeNames(Arrays.asList(attributeNames));
            return this;
        }

        public final Collection<String> getAttributeValues() {
            if (this.attributeValues instanceof SdkAutoConstructList) {
                return null;
            }
            return this.attributeValues;
        }

        public final void setAttributeValues(Collection<String> attributeValues) {
            this.attributeValues = _attributeValuesListCopier.copy(attributeValues);
        }

        @Override
        public final Builder attributeValues(Collection<String> attributeValues) {
            this.attributeValues = _attributeValuesListCopier.copy(attributeValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeValues(String ... attributeValues) {
            this.attributeValues(Arrays.asList(attributeValues));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getListResponseScope() {
            return this.listResponseScope;
        }

        public final void setListResponseScope(String listResponseScope) {
            this.listResponseScope = listResponseScope;
        }

        @Override
        public final Builder listResponseScope(String listResponseScope) {
            this.listResponseScope = listResponseScope;
            return this;
        }

        @Override
        public final Builder listResponseScope(ListResponseScope listResponseScope) {
            this.listResponseScope(listResponseScope == null ? null : listResponseScope.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListVehiclesRequest build() {
            return new ListVehiclesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IoTFleetWiseRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListVehiclesRequest> {
        public Builder modelManifestArn(String var1);

        public Builder attributeNames(Collection<String> var1);

        public Builder attributeNames(String ... var1);

        public Builder attributeValues(Collection<String> var1);

        public Builder attributeValues(String ... var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder listResponseScope(String var1);

        public Builder listResponseScope(ListResponseScope var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

