/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotfleetwise.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotfleetwise.model.IoTFleetWiseException;
import software.amazon.awssdk.services.iotfleetwise.model.Node;
import software.amazon.awssdk.services.iotfleetwise.model.NodesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InvalidNodeException
extends IoTFleetWiseException
implements ToCopyableBuilder<Builder, InvalidNodeException> {
    private static final SdkField<List<Node>> INVALID_NODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("invalidNodes").getter(InvalidNodeException.getter(InvalidNodeException::invalidNodes)).setter(InvalidNodeException.setter(Builder::invalidNodes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("invalidNodes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Node::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("reason").getter(InvalidNodeException.getter(InvalidNodeException::reason)).setter(InvalidNodeException.setter(Builder::reason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INVALID_NODES_FIELD, REASON_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InvalidNodeException.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<Node> invalidNodes;
    private final String reason;

    private InvalidNodeException(BuilderImpl builder) {
        super(builder);
        this.invalidNodes = builder.invalidNodes;
        this.reason = builder.reason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public boolean hasInvalidNodes() {
        return this.invalidNodes != null && !(this.invalidNodes instanceof SdkAutoConstructList);
    }

    public List<Node> invalidNodes() {
        return this.invalidNodes;
    }

    public String reason() {
        return this.reason;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("invalidNodes", INVALID_NODES_FIELD);
        map.put("reason", REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InvalidNodeException, T> g) {
        return obj -> g.apply((InvalidNodeException)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTFleetWiseException.BuilderImpl
    implements Builder {
        private List<Node> invalidNodes = DefaultSdkAutoConstructList.getInstance();
        private String reason;

        private BuilderImpl() {
        }

        private BuilderImpl(InvalidNodeException model) {
            super(model);
            this.invalidNodes(model.invalidNodes);
            this.reason(model.reason);
        }

        public final List<Node.Builder> getInvalidNodes() {
            List<Node.Builder> result = NodesCopier.copyToBuilder(this.invalidNodes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInvalidNodes(Collection<Node.BuilderImpl> invalidNodes) {
            this.invalidNodes = NodesCopier.copyFromBuilder(invalidNodes);
        }

        @Override
        public final Builder invalidNodes(Collection<Node> invalidNodes) {
            this.invalidNodes = NodesCopier.copy(invalidNodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder invalidNodes(Node ... invalidNodes) {
            this.invalidNodes(Arrays.asList(invalidNodes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder invalidNodes(Consumer<Node.Builder> ... invalidNodes) {
            this.invalidNodes(Stream.of(invalidNodes).map(c -> (Node)((Node.Builder)Node.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getReason() {
            return this.reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public BuilderImpl writableStackTrace(Boolean writableStackTrace) {
            this.writableStackTrace = writableStackTrace;
            return this;
        }

        @Override
        public InvalidNodeException build() {
            return new InvalidNodeException(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InvalidNodeException>,
    IoTFleetWiseException.Builder {
        public Builder invalidNodes(Collection<Node> var1);

        public Builder invalidNodes(Node ... var1);

        public Builder invalidNodes(Consumer<Node.Builder> ... var1);

        public Builder reason(String var1);

        @Override
        public Builder awsErrorDetails(AwsErrorDetails var1);

        @Override
        public Builder message(String var1);

        @Override
        public Builder requestId(String var1);

        @Override
        public Builder statusCode(int var1);

        @Override
        public Builder cause(Throwable var1);

        @Override
        public Builder writableStackTrace(Boolean var1);
    }
}

