/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotfleetwise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iotfleetwise.model.ConditionBasedSignalFetchConfig;
import software.amazon.awssdk.services.iotfleetwise.model.TimeBasedSignalFetchConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SignalFetchConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SignalFetchConfig> {
    private static final SdkField<TimeBasedSignalFetchConfig> TIME_BASED_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("timeBased").getter(SignalFetchConfig.getter(SignalFetchConfig::timeBased)).setter(SignalFetchConfig.setter(Builder::timeBased)).constructor(TimeBasedSignalFetchConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeBased").build()}).build();
    private static final SdkField<ConditionBasedSignalFetchConfig> CONDITION_BASED_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("conditionBased").getter(SignalFetchConfig.getter(SignalFetchConfig::conditionBased)).setter(SignalFetchConfig.setter(Builder::conditionBased)).constructor(ConditionBasedSignalFetchConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conditionBased").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIME_BASED_FIELD, CONDITION_BASED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SignalFetchConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final TimeBasedSignalFetchConfig timeBased;
    private final ConditionBasedSignalFetchConfig conditionBased;
    private final Type type;

    private SignalFetchConfig(BuilderImpl builder) {
        this.timeBased = builder.timeBased;
        this.conditionBased = builder.conditionBased;
        this.type = builder.type;
    }

    public final TimeBasedSignalFetchConfig timeBased() {
        return this.timeBased;
    }

    public final ConditionBasedSignalFetchConfig conditionBased() {
        return this.conditionBased;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.timeBased());
        hashCode = 31 * hashCode + Objects.hashCode(this.conditionBased());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SignalFetchConfig)) {
            return false;
        }
        SignalFetchConfig other = (SignalFetchConfig)obj;
        return Objects.equals(this.timeBased(), other.timeBased()) && Objects.equals(this.conditionBased(), other.conditionBased());
    }

    public final String toString() {
        return ToString.builder((String)"SignalFetchConfig").add("TimeBased", (Object)this.timeBased()).add("ConditionBased", (Object)this.conditionBased()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "timeBased": {
                return Optional.ofNullable(clazz.cast(this.timeBased()));
            }
            case "conditionBased": {
                return Optional.ofNullable(clazz.cast(this.conditionBased()));
            }
        }
        return Optional.empty();
    }

    public static SignalFetchConfig fromTimeBased(TimeBasedSignalFetchConfig timeBased) {
        return (SignalFetchConfig)SignalFetchConfig.builder().timeBased(timeBased).build();
    }

    public static SignalFetchConfig fromTimeBased(Consumer<TimeBasedSignalFetchConfig.Builder> timeBased) {
        TimeBasedSignalFetchConfig.Builder builder = TimeBasedSignalFetchConfig.builder();
        timeBased.accept(builder);
        return SignalFetchConfig.fromTimeBased((TimeBasedSignalFetchConfig)builder.build());
    }

    public static SignalFetchConfig fromConditionBased(ConditionBasedSignalFetchConfig conditionBased) {
        return (SignalFetchConfig)SignalFetchConfig.builder().conditionBased(conditionBased).build();
    }

    public static SignalFetchConfig fromConditionBased(Consumer<ConditionBasedSignalFetchConfig.Builder> conditionBased) {
        ConditionBasedSignalFetchConfig.Builder builder = ConditionBasedSignalFetchConfig.builder();
        conditionBased.accept(builder);
        return SignalFetchConfig.fromConditionBased((ConditionBasedSignalFetchConfig)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("timeBased", TIME_BASED_FIELD);
        map.put("conditionBased", CONDITION_BASED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SignalFetchConfig, T> g) {
        return obj -> g.apply((SignalFetchConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        TIME_BASED,
        CONDITION_BASED,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private TimeBasedSignalFetchConfig timeBased;
        private ConditionBasedSignalFetchConfig conditionBased;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(SignalFetchConfig model) {
            this.timeBased(model.timeBased);
            this.conditionBased(model.conditionBased);
        }

        public final TimeBasedSignalFetchConfig.Builder getTimeBased() {
            return this.timeBased != null ? this.timeBased.toBuilder() : null;
        }

        public final void setTimeBased(TimeBasedSignalFetchConfig.BuilderImpl timeBased) {
            TimeBasedSignalFetchConfig oldValue = this.timeBased;
            this.timeBased = timeBased != null ? timeBased.build() : null;
            this.handleUnionValueChange(Type.TIME_BASED, oldValue, this.timeBased);
        }

        @Override
        public final Builder timeBased(TimeBasedSignalFetchConfig timeBased) {
            TimeBasedSignalFetchConfig oldValue = this.timeBased;
            this.timeBased = timeBased;
            this.handleUnionValueChange(Type.TIME_BASED, oldValue, this.timeBased);
            return this;
        }

        public final ConditionBasedSignalFetchConfig.Builder getConditionBased() {
            return this.conditionBased != null ? this.conditionBased.toBuilder() : null;
        }

        public final void setConditionBased(ConditionBasedSignalFetchConfig.BuilderImpl conditionBased) {
            ConditionBasedSignalFetchConfig oldValue = this.conditionBased;
            this.conditionBased = conditionBased != null ? conditionBased.build() : null;
            this.handleUnionValueChange(Type.CONDITION_BASED, oldValue, this.conditionBased);
        }

        @Override
        public final Builder conditionBased(ConditionBasedSignalFetchConfig conditionBased) {
            ConditionBasedSignalFetchConfig oldValue = this.conditionBased;
            this.conditionBased = conditionBased;
            this.handleUnionValueChange(Type.CONDITION_BASED, oldValue, this.conditionBased);
            return this;
        }

        public SignalFetchConfig build() {
            return new SignalFetchConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SignalFetchConfig> {
        public Builder timeBased(TimeBasedSignalFetchConfig var1);

        default public Builder timeBased(Consumer<TimeBasedSignalFetchConfig.Builder> timeBased) {
            return this.timeBased((TimeBasedSignalFetchConfig)((TimeBasedSignalFetchConfig.Builder)TimeBasedSignalFetchConfig.builder().applyMutation(timeBased)).build());
        }

        public Builder conditionBased(ConditionBasedSignalFetchConfig var1);

        default public Builder conditionBased(Consumer<ConditionBasedSignalFetchConfig.Builder> conditionBased) {
            return this.conditionBased((ConditionBasedSignalFetchConfig)((ConditionBasedSignalFetchConfig.Builder)ConditionBasedSignalFetchConfig.builder().applyMutation(conditionBased)).build());
        }
    }
}

