/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotfleetwise.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotfleetwise.model.IamResources;
import software.amazon.awssdk.services.iotfleetwise.model.IoTFleetWiseResponse;
import software.amazon.awssdk.services.iotfleetwise.model.RegistrationStatus;
import software.amazon.awssdk.services.iotfleetwise.model.TimestreamResources;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RegisterAccountResponse
extends IoTFleetWiseResponse
implements ToCopyableBuilder<Builder, RegisterAccountResponse> {
    private static final SdkField<String> REGISTER_ACCOUNT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("registerAccountStatus").getter(RegisterAccountResponse.getter(RegisterAccountResponse::registerAccountStatusAsString)).setter(RegisterAccountResponse.setter(Builder::registerAccountStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registerAccountStatus").build()}).build();
    private static final SdkField<TimestreamResources> TIMESTREAM_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("timestreamResources").getter(RegisterAccountResponse.getter(RegisterAccountResponse::timestreamResources)).setter(RegisterAccountResponse.setter(Builder::timestreamResources)).constructor(TimestreamResources::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestreamResources").build()}).build();
    private static final SdkField<IamResources> IAM_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("iamResources").getter(RegisterAccountResponse.getter(RegisterAccountResponse::iamResources)).setter(RegisterAccountResponse.setter(Builder::iamResources)).constructor(IamResources::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamResources").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(RegisterAccountResponse.getter(RegisterAccountResponse::creationTime)).setter(RegisterAccountResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFICATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastModificationTime").getter(RegisterAccountResponse.getter(RegisterAccountResponse::lastModificationTime)).setter(RegisterAccountResponse.setter(Builder::lastModificationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModificationTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTER_ACCOUNT_STATUS_FIELD, TIMESTREAM_RESOURCES_FIELD, IAM_RESOURCES_FIELD, CREATION_TIME_FIELD, LAST_MODIFICATION_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RegisterAccountResponse.memberNameToFieldInitializer();
    private final String registerAccountStatus;
    private final TimestreamResources timestreamResources;
    private final IamResources iamResources;
    private final Instant creationTime;
    private final Instant lastModificationTime;

    private RegisterAccountResponse(BuilderImpl builder) {
        super(builder);
        this.registerAccountStatus = builder.registerAccountStatus;
        this.timestreamResources = builder.timestreamResources;
        this.iamResources = builder.iamResources;
        this.creationTime = builder.creationTime;
        this.lastModificationTime = builder.lastModificationTime;
    }

    public final RegistrationStatus registerAccountStatus() {
        return RegistrationStatus.fromValue(this.registerAccountStatus);
    }

    public final String registerAccountStatusAsString() {
        return this.registerAccountStatus;
    }

    public final TimestreamResources timestreamResources() {
        return this.timestreamResources;
    }

    public final IamResources iamResources() {
        return this.iamResources;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastModificationTime() {
        return this.lastModificationTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.registerAccountStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestreamResources());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamResources());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModificationTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterAccountResponse)) {
            return false;
        }
        RegisterAccountResponse other = (RegisterAccountResponse)((Object)obj);
        return Objects.equals(this.registerAccountStatusAsString(), other.registerAccountStatusAsString()) && Objects.equals(this.timestreamResources(), other.timestreamResources()) && Objects.equals(this.iamResources(), other.iamResources()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastModificationTime(), other.lastModificationTime());
    }

    public final String toString() {
        return ToString.builder((String)"RegisterAccountResponse").add("RegisterAccountStatus", (Object)this.registerAccountStatusAsString()).add("TimestreamResources", (Object)this.timestreamResources()).add("IamResources", (Object)this.iamResources()).add("CreationTime", (Object)this.creationTime()).add("LastModificationTime", (Object)this.lastModificationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "registerAccountStatus": {
                return Optional.ofNullable(clazz.cast(this.registerAccountStatusAsString()));
            }
            case "timestreamResources": {
                return Optional.ofNullable(clazz.cast(this.timestreamResources()));
            }
            case "iamResources": {
                return Optional.ofNullable(clazz.cast(this.iamResources()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "lastModificationTime": {
                return Optional.ofNullable(clazz.cast(this.lastModificationTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("registerAccountStatus", REGISTER_ACCOUNT_STATUS_FIELD);
        map.put("timestreamResources", TIMESTREAM_RESOURCES_FIELD);
        map.put("iamResources", IAM_RESOURCES_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("lastModificationTime", LAST_MODIFICATION_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RegisterAccountResponse, T> g) {
        return obj -> g.apply((RegisterAccountResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTFleetWiseResponse.BuilderImpl
    implements Builder {
        private String registerAccountStatus;
        private TimestreamResources timestreamResources;
        private IamResources iamResources;
        private Instant creationTime;
        private Instant lastModificationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterAccountResponse model) {
            super(model);
            this.registerAccountStatus(model.registerAccountStatus);
            this.timestreamResources(model.timestreamResources);
            this.iamResources(model.iamResources);
            this.creationTime(model.creationTime);
            this.lastModificationTime(model.lastModificationTime);
        }

        public final String getRegisterAccountStatus() {
            return this.registerAccountStatus;
        }

        public final void setRegisterAccountStatus(String registerAccountStatus) {
            this.registerAccountStatus = registerAccountStatus;
        }

        @Override
        public final Builder registerAccountStatus(String registerAccountStatus) {
            this.registerAccountStatus = registerAccountStatus;
            return this;
        }

        @Override
        public final Builder registerAccountStatus(RegistrationStatus registerAccountStatus) {
            this.registerAccountStatus(registerAccountStatus == null ? null : registerAccountStatus.toString());
            return this;
        }

        public final TimestreamResources.Builder getTimestreamResources() {
            return this.timestreamResources != null ? this.timestreamResources.toBuilder() : null;
        }

        public final void setTimestreamResources(TimestreamResources.BuilderImpl timestreamResources) {
            this.timestreamResources = timestreamResources != null ? timestreamResources.build() : null;
        }

        @Override
        public final Builder timestreamResources(TimestreamResources timestreamResources) {
            this.timestreamResources = timestreamResources;
            return this;
        }

        public final IamResources.Builder getIamResources() {
            return this.iamResources != null ? this.iamResources.toBuilder() : null;
        }

        public final void setIamResources(IamResources.BuilderImpl iamResources) {
            this.iamResources = iamResources != null ? iamResources.build() : null;
        }

        @Override
        public final Builder iamResources(IamResources iamResources) {
            this.iamResources = iamResources;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModificationTime() {
            return this.lastModificationTime;
        }

        public final void setLastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
        }

        @Override
        public final Builder lastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
            return this;
        }

        @Override
        public RegisterAccountResponse build() {
            return new RegisterAccountResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IoTFleetWiseResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RegisterAccountResponse> {
        public Builder registerAccountStatus(String var1);

        public Builder registerAccountStatus(RegistrationStatus var1);

        public Builder timestreamResources(TimestreamResources var1);

        default public Builder timestreamResources(Consumer<TimestreamResources.Builder> timestreamResources) {
            return this.timestreamResources((TimestreamResources)((TimestreamResources.Builder)TimestreamResources.builder().applyMutation(timestreamResources)).build());
        }

        public Builder iamResources(IamResources var1);

        default public Builder iamResources(Consumer<IamResources.Builder> iamResources) {
            return this.iamResources((IamResources)((IamResources.Builder)IamResources.builder().applyMutation(iamResources)).build());
        }

        public Builder creationTime(Instant var1);

        public Builder lastModificationTime(Instant var1);
    }
}

