/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotfleetwise.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iotfleetwise.model.IoTFleetWiseRequest;
import software.amazon.awssdk.services.iotfleetwise.model.UpdateMode;
import software.amazon.awssdk.services.iotfleetwise.model._attributesMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateVehicleRequest
extends IoTFleetWiseRequest
implements ToCopyableBuilder<Builder, UpdateVehicleRequest> {
    private static final SdkField<String> VEHICLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("vehicleName").getter(UpdateVehicleRequest.getter(UpdateVehicleRequest::vehicleName)).setter(UpdateVehicleRequest.setter(Builder::vehicleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vehicleName").build()}).build();
    private static final SdkField<String> MODEL_MANIFEST_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("modelManifestArn").getter(UpdateVehicleRequest.getter(UpdateVehicleRequest::modelManifestArn)).setter(UpdateVehicleRequest.setter(Builder::modelManifestArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelManifestArn").build()}).build();
    private static final SdkField<String> DECODER_MANIFEST_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("decoderManifestArn").getter(UpdateVehicleRequest.getter(UpdateVehicleRequest::decoderManifestArn)).setter(UpdateVehicleRequest.setter(Builder::decoderManifestArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("decoderManifestArn").build()}).build();
    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("attributes").getter(UpdateVehicleRequest.getter(UpdateVehicleRequest::attributes)).setter(UpdateVehicleRequest.setter(Builder::attributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> ATTRIBUTE_UPDATE_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("attributeUpdateMode").getter(UpdateVehicleRequest.getter(UpdateVehicleRequest::attributeUpdateModeAsString)).setter(UpdateVehicleRequest.setter(Builder::attributeUpdateMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributeUpdateMode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VEHICLE_NAME_FIELD, MODEL_MANIFEST_ARN_FIELD, DECODER_MANIFEST_ARN_FIELD, ATTRIBUTES_FIELD, ATTRIBUTE_UPDATE_MODE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("vehicleName", VEHICLE_NAME_FIELD);
            this.put("modelManifestArn", MODEL_MANIFEST_ARN_FIELD);
            this.put("decoderManifestArn", DECODER_MANIFEST_ARN_FIELD);
            this.put("attributes", ATTRIBUTES_FIELD);
            this.put("attributeUpdateMode", ATTRIBUTE_UPDATE_MODE_FIELD);
        }
    });
    private final String vehicleName;
    private final String modelManifestArn;
    private final String decoderManifestArn;
    private final Map<String, String> attributes;
    private final String attributeUpdateMode;

    private UpdateVehicleRequest(BuilderImpl builder) {
        super(builder);
        this.vehicleName = builder.vehicleName;
        this.modelManifestArn = builder.modelManifestArn;
        this.decoderManifestArn = builder.decoderManifestArn;
        this.attributes = builder.attributes;
        this.attributeUpdateMode = builder.attributeUpdateMode;
    }

    public final String vehicleName() {
        return this.vehicleName;
    }

    public final String modelManifestArn() {
        return this.modelManifestArn;
    }

    public final String decoderManifestArn() {
        return this.decoderManifestArn;
    }

    public final boolean hasAttributes() {
        return this.attributes != null && !(this.attributes instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> attributes() {
        return this.attributes;
    }

    public final UpdateMode attributeUpdateMode() {
        return UpdateMode.fromValue(this.attributeUpdateMode);
    }

    public final String attributeUpdateModeAsString() {
        return this.attributeUpdateMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.vehicleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelManifestArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.decoderManifestArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributes() ? this.attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeUpdateModeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateVehicleRequest)) {
            return false;
        }
        UpdateVehicleRequest other = (UpdateVehicleRequest)((Object)obj);
        return Objects.equals(this.vehicleName(), other.vehicleName()) && Objects.equals(this.modelManifestArn(), other.modelManifestArn()) && Objects.equals(this.decoderManifestArn(), other.decoderManifestArn()) && this.hasAttributes() == other.hasAttributes() && Objects.equals(this.attributes(), other.attributes()) && Objects.equals(this.attributeUpdateModeAsString(), other.attributeUpdateModeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateVehicleRequest").add("VehicleName", (Object)this.vehicleName()).add("ModelManifestArn", (Object)this.modelManifestArn()).add("DecoderManifestArn", (Object)this.decoderManifestArn()).add("Attributes", this.hasAttributes() ? this.attributes() : null).add("AttributeUpdateMode", (Object)this.attributeUpdateModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "vehicleName": {
                return Optional.ofNullable(clazz.cast(this.vehicleName()));
            }
            case "modelManifestArn": {
                return Optional.ofNullable(clazz.cast(this.modelManifestArn()));
            }
            case "decoderManifestArn": {
                return Optional.ofNullable(clazz.cast(this.decoderManifestArn()));
            }
            case "attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
            case "attributeUpdateMode": {
                return Optional.ofNullable(clazz.cast(this.attributeUpdateModeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateVehicleRequest, T> g) {
        return obj -> g.apply((UpdateVehicleRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTFleetWiseRequest.BuilderImpl
    implements Builder {
        private String vehicleName;
        private String modelManifestArn;
        private String decoderManifestArn;
        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();
        private String attributeUpdateMode;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateVehicleRequest model) {
            super(model);
            this.vehicleName(model.vehicleName);
            this.modelManifestArn(model.modelManifestArn);
            this.decoderManifestArn(model.decoderManifestArn);
            this.attributes(model.attributes);
            this.attributeUpdateMode(model.attributeUpdateMode);
        }

        public final String getVehicleName() {
            return this.vehicleName;
        }

        public final void setVehicleName(String vehicleName) {
            this.vehicleName = vehicleName;
        }

        @Override
        public final Builder vehicleName(String vehicleName) {
            this.vehicleName = vehicleName;
            return this;
        }

        public final String getModelManifestArn() {
            return this.modelManifestArn;
        }

        public final void setModelManifestArn(String modelManifestArn) {
            this.modelManifestArn = modelManifestArn;
        }

        @Override
        public final Builder modelManifestArn(String modelManifestArn) {
            this.modelManifestArn = modelManifestArn;
            return this;
        }

        public final String getDecoderManifestArn() {
            return this.decoderManifestArn;
        }

        public final void setDecoderManifestArn(String decoderManifestArn) {
            this.decoderManifestArn = decoderManifestArn;
        }

        @Override
        public final Builder decoderManifestArn(String decoderManifestArn) {
            this.decoderManifestArn = decoderManifestArn;
            return this;
        }

        public final Map<String, String> getAttributes() {
            if (this.attributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.attributes;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = _attributesMapCopier.copy(attributes);
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = _attributesMapCopier.copy(attributes);
            return this;
        }

        public final String getAttributeUpdateMode() {
            return this.attributeUpdateMode;
        }

        public final void setAttributeUpdateMode(String attributeUpdateMode) {
            this.attributeUpdateMode = attributeUpdateMode;
        }

        @Override
        public final Builder attributeUpdateMode(String attributeUpdateMode) {
            this.attributeUpdateMode = attributeUpdateMode;
            return this;
        }

        @Override
        public final Builder attributeUpdateMode(UpdateMode attributeUpdateMode) {
            this.attributeUpdateMode(attributeUpdateMode == null ? null : attributeUpdateMode.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateVehicleRequest build() {
            return new UpdateVehicleRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IoTFleetWiseRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateVehicleRequest> {
        public Builder vehicleName(String var1);

        public Builder modelManifestArn(String var1);

        public Builder decoderManifestArn(String var1);

        public Builder attributes(Map<String, String> var1);

        public Builder attributeUpdateMode(String var1);

        public Builder attributeUpdateMode(UpdateMode var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

