/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotfleetwise.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotfleetwise.model.IoTFleetWiseRequest;
import software.amazon.awssdk.services.iotfleetwise.model.Node;
import software.amazon.awssdk.services.iotfleetwise.model.NodePathsCopier;
import software.amazon.awssdk.services.iotfleetwise.model.NodesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateSignalCatalogRequest
extends IoTFleetWiseRequest
implements ToCopyableBuilder<Builder, UpdateSignalCatalogRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(UpdateSignalCatalogRequest.getter(UpdateSignalCatalogRequest::name)).setter(UpdateSignalCatalogRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateSignalCatalogRequest.getter(UpdateSignalCatalogRequest::description)).setter(UpdateSignalCatalogRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<Node>> NODES_TO_ADD_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("nodesToAdd").getter(UpdateSignalCatalogRequest.getter(UpdateSignalCatalogRequest::nodesToAdd)).setter(UpdateSignalCatalogRequest.setter(Builder::nodesToAdd)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodesToAdd").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Node::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Node>> NODES_TO_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("nodesToUpdate").getter(UpdateSignalCatalogRequest.getter(UpdateSignalCatalogRequest::nodesToUpdate)).setter(UpdateSignalCatalogRequest.setter(Builder::nodesToUpdate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodesToUpdate").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Node::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> NODES_TO_REMOVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("nodesToRemove").getter(UpdateSignalCatalogRequest.getter(UpdateSignalCatalogRequest::nodesToRemove)).setter(UpdateSignalCatalogRequest.setter(Builder::nodesToRemove)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodesToRemove").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, NODES_TO_ADD_FIELD, NODES_TO_UPDATE_FIELD, NODES_TO_REMOVE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("name", NAME_FIELD);
            this.put("description", DESCRIPTION_FIELD);
            this.put("nodesToAdd", NODES_TO_ADD_FIELD);
            this.put("nodesToUpdate", NODES_TO_UPDATE_FIELD);
            this.put("nodesToRemove", NODES_TO_REMOVE_FIELD);
        }
    });
    private final String name;
    private final String description;
    private final List<Node> nodesToAdd;
    private final List<Node> nodesToUpdate;
    private final List<String> nodesToRemove;

    private UpdateSignalCatalogRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.nodesToAdd = builder.nodesToAdd;
        this.nodesToUpdate = builder.nodesToUpdate;
        this.nodesToRemove = builder.nodesToRemove;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasNodesToAdd() {
        return this.nodesToAdd != null && !(this.nodesToAdd instanceof SdkAutoConstructList);
    }

    public final List<Node> nodesToAdd() {
        return this.nodesToAdd;
    }

    public final boolean hasNodesToUpdate() {
        return this.nodesToUpdate != null && !(this.nodesToUpdate instanceof SdkAutoConstructList);
    }

    public final List<Node> nodesToUpdate() {
        return this.nodesToUpdate;
    }

    public final boolean hasNodesToRemove() {
        return this.nodesToRemove != null && !(this.nodesToRemove instanceof SdkAutoConstructList);
    }

    public final List<String> nodesToRemove() {
        return this.nodesToRemove;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNodesToAdd() ? this.nodesToAdd() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNodesToUpdate() ? this.nodesToUpdate() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNodesToRemove() ? this.nodesToRemove() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSignalCatalogRequest)) {
            return false;
        }
        UpdateSignalCatalogRequest other = (UpdateSignalCatalogRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && this.hasNodesToAdd() == other.hasNodesToAdd() && Objects.equals(this.nodesToAdd(), other.nodesToAdd()) && this.hasNodesToUpdate() == other.hasNodesToUpdate() && Objects.equals(this.nodesToUpdate(), other.nodesToUpdate()) && this.hasNodesToRemove() == other.hasNodesToRemove() && Objects.equals(this.nodesToRemove(), other.nodesToRemove());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateSignalCatalogRequest").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("NodesToAdd", this.hasNodesToAdd() ? this.nodesToAdd() : null).add("NodesToUpdate", this.hasNodesToUpdate() ? this.nodesToUpdate() : null).add("NodesToRemove", this.hasNodesToRemove() ? this.nodesToRemove() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "nodesToAdd": {
                return Optional.ofNullable(clazz.cast(this.nodesToAdd()));
            }
            case "nodesToUpdate": {
                return Optional.ofNullable(clazz.cast(this.nodesToUpdate()));
            }
            case "nodesToRemove": {
                return Optional.ofNullable(clazz.cast(this.nodesToRemove()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateSignalCatalogRequest, T> g) {
        return obj -> g.apply((UpdateSignalCatalogRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTFleetWiseRequest.BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private List<Node> nodesToAdd = DefaultSdkAutoConstructList.getInstance();
        private List<Node> nodesToUpdate = DefaultSdkAutoConstructList.getInstance();
        private List<String> nodesToRemove = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSignalCatalogRequest model) {
            super(model);
            this.name(model.name);
            this.description(model.description);
            this.nodesToAdd(model.nodesToAdd);
            this.nodesToUpdate(model.nodesToUpdate);
            this.nodesToRemove(model.nodesToRemove);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<Node.Builder> getNodesToAdd() {
            List<Node.Builder> result = NodesCopier.copyToBuilder(this.nodesToAdd);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNodesToAdd(Collection<Node.BuilderImpl> nodesToAdd) {
            this.nodesToAdd = NodesCopier.copyFromBuilder(nodesToAdd);
        }

        @Override
        public final Builder nodesToAdd(Collection<Node> nodesToAdd) {
            this.nodesToAdd = NodesCopier.copy(nodesToAdd);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodesToAdd(Node ... nodesToAdd) {
            this.nodesToAdd(Arrays.asList(nodesToAdd));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodesToAdd(Consumer<Node.Builder> ... nodesToAdd) {
            this.nodesToAdd(Stream.of(nodesToAdd).map(c -> (Node)((Node.Builder)Node.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Node.Builder> getNodesToUpdate() {
            List<Node.Builder> result = NodesCopier.copyToBuilder(this.nodesToUpdate);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNodesToUpdate(Collection<Node.BuilderImpl> nodesToUpdate) {
            this.nodesToUpdate = NodesCopier.copyFromBuilder(nodesToUpdate);
        }

        @Override
        public final Builder nodesToUpdate(Collection<Node> nodesToUpdate) {
            this.nodesToUpdate = NodesCopier.copy(nodesToUpdate);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodesToUpdate(Node ... nodesToUpdate) {
            this.nodesToUpdate(Arrays.asList(nodesToUpdate));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodesToUpdate(Consumer<Node.Builder> ... nodesToUpdate) {
            this.nodesToUpdate(Stream.of(nodesToUpdate).map(c -> (Node)((Node.Builder)Node.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getNodesToRemove() {
            if (this.nodesToRemove instanceof SdkAutoConstructList) {
                return null;
            }
            return this.nodesToRemove;
        }

        public final void setNodesToRemove(Collection<String> nodesToRemove) {
            this.nodesToRemove = NodePathsCopier.copy(nodesToRemove);
        }

        @Override
        public final Builder nodesToRemove(Collection<String> nodesToRemove) {
            this.nodesToRemove = NodePathsCopier.copy(nodesToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodesToRemove(String ... nodesToRemove) {
            this.nodesToRemove(Arrays.asList(nodesToRemove));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSignalCatalogRequest build() {
            return new UpdateSignalCatalogRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IoTFleetWiseRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateSignalCatalogRequest> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder nodesToAdd(Collection<Node> var1);

        public Builder nodesToAdd(Node ... var1);

        public Builder nodesToAdd(Consumer<Node.Builder> ... var1);

        public Builder nodesToUpdate(Collection<Node> var1);

        public Builder nodesToUpdate(Node ... var1);

        public Builder nodesToUpdate(Consumer<Node.Builder> ... var1);

        public Builder nodesToRemove(Collection<String> var1);

        public Builder nodesToRemove(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

