/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotfleetwise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotfleetwise.model.EventExpressionListCopier;
import software.amazon.awssdk.services.iotfleetwise.model.SignalFetchConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SignalFetchInformation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SignalFetchInformation> {
    private static final SdkField<String> FULLY_QUALIFIED_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fullyQualifiedName").getter(SignalFetchInformation.getter(SignalFetchInformation::fullyQualifiedName)).setter(SignalFetchInformation.setter(Builder::fullyQualifiedName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fullyQualifiedName").build()}).build();
    private static final SdkField<SignalFetchConfig> SIGNAL_FETCH_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("signalFetchConfig").getter(SignalFetchInformation.getter(SignalFetchInformation::signalFetchConfig)).setter(SignalFetchInformation.setter(Builder::signalFetchConfig)).constructor(SignalFetchConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signalFetchConfig").build()}).build();
    private static final SdkField<Integer> CONDITION_LANGUAGE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("conditionLanguageVersion").getter(SignalFetchInformation.getter(SignalFetchInformation::conditionLanguageVersion)).setter(SignalFetchInformation.setter(Builder::conditionLanguageVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conditionLanguageVersion").build()}).build();
    private static final SdkField<List<String>> ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("actions").getter(SignalFetchInformation.getter(SignalFetchInformation::actions)).setter(SignalFetchInformation.setter(Builder::actions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FULLY_QUALIFIED_NAME_FIELD, SIGNAL_FETCH_CONFIG_FIELD, CONDITION_LANGUAGE_VERSION_FIELD, ACTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("fullyQualifiedName", FULLY_QUALIFIED_NAME_FIELD);
            this.put("signalFetchConfig", SIGNAL_FETCH_CONFIG_FIELD);
            this.put("conditionLanguageVersion", CONDITION_LANGUAGE_VERSION_FIELD);
            this.put("actions", ACTIONS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String fullyQualifiedName;
    private final SignalFetchConfig signalFetchConfig;
    private final Integer conditionLanguageVersion;
    private final List<String> actions;

    private SignalFetchInformation(BuilderImpl builder) {
        this.fullyQualifiedName = builder.fullyQualifiedName;
        this.signalFetchConfig = builder.signalFetchConfig;
        this.conditionLanguageVersion = builder.conditionLanguageVersion;
        this.actions = builder.actions;
    }

    public final String fullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    public final SignalFetchConfig signalFetchConfig() {
        return this.signalFetchConfig;
    }

    public final Integer conditionLanguageVersion() {
        return this.conditionLanguageVersion;
    }

    public final boolean hasActions() {
        return this.actions != null && !(this.actions instanceof SdkAutoConstructList);
    }

    public final List<String> actions() {
        return this.actions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fullyQualifiedName());
        hashCode = 31 * hashCode + Objects.hashCode(this.signalFetchConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.conditionLanguageVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActions() ? this.actions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SignalFetchInformation)) {
            return false;
        }
        SignalFetchInformation other = (SignalFetchInformation)obj;
        return Objects.equals(this.fullyQualifiedName(), other.fullyQualifiedName()) && Objects.equals(this.signalFetchConfig(), other.signalFetchConfig()) && Objects.equals(this.conditionLanguageVersion(), other.conditionLanguageVersion()) && this.hasActions() == other.hasActions() && Objects.equals(this.actions(), other.actions());
    }

    public final String toString() {
        return ToString.builder((String)"SignalFetchInformation").add("FullyQualifiedName", (Object)this.fullyQualifiedName()).add("SignalFetchConfig", (Object)this.signalFetchConfig()).add("ConditionLanguageVersion", (Object)this.conditionLanguageVersion()).add("Actions", (Object)(this.actions() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "fullyQualifiedName": {
                return Optional.ofNullable(clazz.cast(this.fullyQualifiedName()));
            }
            case "signalFetchConfig": {
                return Optional.ofNullable(clazz.cast(this.signalFetchConfig()));
            }
            case "conditionLanguageVersion": {
                return Optional.ofNullable(clazz.cast(this.conditionLanguageVersion()));
            }
            case "actions": {
                return Optional.ofNullable(clazz.cast(this.actions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SignalFetchInformation, T> g) {
        return obj -> g.apply((SignalFetchInformation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String fullyQualifiedName;
        private SignalFetchConfig signalFetchConfig;
        private Integer conditionLanguageVersion;
        private List<String> actions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SignalFetchInformation model) {
            this.fullyQualifiedName(model.fullyQualifiedName);
            this.signalFetchConfig(model.signalFetchConfig);
            this.conditionLanguageVersion(model.conditionLanguageVersion);
            this.actions(model.actions);
        }

        public final String getFullyQualifiedName() {
            return this.fullyQualifiedName;
        }

        public final void setFullyQualifiedName(String fullyQualifiedName) {
            this.fullyQualifiedName = fullyQualifiedName;
        }

        @Override
        public final Builder fullyQualifiedName(String fullyQualifiedName) {
            this.fullyQualifiedName = fullyQualifiedName;
            return this;
        }

        public final SignalFetchConfig.Builder getSignalFetchConfig() {
            return this.signalFetchConfig != null ? this.signalFetchConfig.toBuilder() : null;
        }

        public final void setSignalFetchConfig(SignalFetchConfig.BuilderImpl signalFetchConfig) {
            this.signalFetchConfig = signalFetchConfig != null ? signalFetchConfig.build() : null;
        }

        @Override
        public final Builder signalFetchConfig(SignalFetchConfig signalFetchConfig) {
            this.signalFetchConfig = signalFetchConfig;
            return this;
        }

        public final Integer getConditionLanguageVersion() {
            return this.conditionLanguageVersion;
        }

        public final void setConditionLanguageVersion(Integer conditionLanguageVersion) {
            this.conditionLanguageVersion = conditionLanguageVersion;
        }

        @Override
        public final Builder conditionLanguageVersion(Integer conditionLanguageVersion) {
            this.conditionLanguageVersion = conditionLanguageVersion;
            return this;
        }

        public final Collection<String> getActions() {
            if (this.actions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.actions;
        }

        public final void setActions(Collection<String> actions) {
            this.actions = EventExpressionListCopier.copy(actions);
        }

        @Override
        public final Builder actions(Collection<String> actions) {
            this.actions = EventExpressionListCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(String ... actions) {
            this.actions(Arrays.asList(actions));
            return this;
        }

        public SignalFetchInformation build() {
            return new SignalFetchInformation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SignalFetchInformation> {
        public Builder fullyQualifiedName(String var1);

        public Builder signalFetchConfig(SignalFetchConfig var1);

        default public Builder signalFetchConfig(Consumer<SignalFetchConfig.Builder> signalFetchConfig) {
            return this.signalFetchConfig((SignalFetchConfig)((SignalFetchConfig.Builder)SignalFetchConfig.builder().applyMutation(signalFetchConfig)).build());
        }

        public Builder conditionLanguageVersion(Integer var1);

        public Builder actions(Collection<String> var1);

        public Builder actions(String ... var1);
    }
}

