/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotfleetwise.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SignalDecoderType {
    CAN_SIGNAL("CAN_SIGNAL"),
    OBD_SIGNAL("OBD_SIGNAL"),
    MESSAGE_SIGNAL("MESSAGE_SIGNAL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SignalDecoderType> VALUE_MAP;
    private final String value;

    private SignalDecoderType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SignalDecoderType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SignalDecoderType> knownValues() {
        EnumSet<SignalDecoderType> knownValues = EnumSet.allOf(SignalDecoderType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SignalDecoderType.class, SignalDecoderType::toString);
    }
}

