/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotfleetwise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotfleetwise.model.NodeDataType;
import software.amazon.awssdk.services.iotfleetwise.model._listOfStringsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Attribute
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Attribute> {
    private static final SdkField<String> FULLY_QUALIFIED_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fullyQualifiedName").getter(Attribute.getter(Attribute::fullyQualifiedName)).setter(Attribute.setter(Builder::fullyQualifiedName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fullyQualifiedName").build()}).build();
    private static final SdkField<String> DATA_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataType").getter(Attribute.getter(Attribute::dataTypeAsString)).setter(Attribute.setter(Builder::dataType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataType").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(Attribute.getter(Attribute::description)).setter(Attribute.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> UNIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("unit").getter(Attribute.getter(Attribute::unit)).setter(Attribute.setter(Builder::unit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unit").build()}).build();
    private static final SdkField<List<String>> ALLOWED_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("allowedValues").getter(Attribute.getter(Attribute::allowedValues)).setter(Attribute.setter(Builder::allowedValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Double> MIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("min").getter(Attribute.getter(Attribute::min)).setter(Attribute.setter(Builder::min)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("min").build()}).build();
    private static final SdkField<Double> MAX_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("max").getter(Attribute.getter(Attribute::max)).setter(Attribute.setter(Builder::max)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("max").build()}).build();
    private static final SdkField<String> ASSIGNED_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assignedValue").getter(Attribute.getter(Attribute::assignedValue)).setter(Attribute.setter(Builder::assignedValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assignedValue").build()}).build();
    private static final SdkField<String> DEFAULT_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("defaultValue").getter(Attribute.getter(Attribute::defaultValue)).setter(Attribute.setter(Builder::defaultValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultValue").build()}).build();
    private static final SdkField<String> DEPRECATION_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deprecationMessage").getter(Attribute.getter(Attribute::deprecationMessage)).setter(Attribute.setter(Builder::deprecationMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deprecationMessage").build()}).build();
    private static final SdkField<String> COMMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("comment").getter(Attribute.getter(Attribute::comment)).setter(Attribute.setter(Builder::comment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("comment").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FULLY_QUALIFIED_NAME_FIELD, DATA_TYPE_FIELD, DESCRIPTION_FIELD, UNIT_FIELD, ALLOWED_VALUES_FIELD, MIN_FIELD, MAX_FIELD, ASSIGNED_VALUE_FIELD, DEFAULT_VALUE_FIELD, DEPRECATION_MESSAGE_FIELD, COMMENT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String fullyQualifiedName;
    private final String dataType;
    private final String description;
    private final String unit;
    private final List<String> allowedValues;
    private final Double min;
    private final Double max;
    private final String assignedValue;
    private final String defaultValue;
    private final String deprecationMessage;
    private final String comment;

    private Attribute(BuilderImpl builder) {
        this.fullyQualifiedName = builder.fullyQualifiedName;
        this.dataType = builder.dataType;
        this.description = builder.description;
        this.unit = builder.unit;
        this.allowedValues = builder.allowedValues;
        this.min = builder.min;
        this.max = builder.max;
        this.assignedValue = builder.assignedValue;
        this.defaultValue = builder.defaultValue;
        this.deprecationMessage = builder.deprecationMessage;
        this.comment = builder.comment;
    }

    public final String fullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    public final NodeDataType dataType() {
        return NodeDataType.fromValue(this.dataType);
    }

    public final String dataTypeAsString() {
        return this.dataType;
    }

    public final String description() {
        return this.description;
    }

    public final String unit() {
        return this.unit;
    }

    public final boolean hasAllowedValues() {
        return this.allowedValues != null && !(this.allowedValues instanceof SdkAutoConstructList);
    }

    public final List<String> allowedValues() {
        return this.allowedValues;
    }

    public final Double min() {
        return this.min;
    }

    public final Double max() {
        return this.max;
    }

    @Deprecated
    public final String assignedValue() {
        return this.assignedValue;
    }

    public final String defaultValue() {
        return this.defaultValue;
    }

    public final String deprecationMessage() {
        return this.deprecationMessage;
    }

    public final String comment() {
        return this.comment;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fullyQualifiedName());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.unit());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllowedValues() ? this.allowedValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.min());
        hashCode = 31 * hashCode + Objects.hashCode(this.max());
        hashCode = 31 * hashCode + Objects.hashCode(this.assignedValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.deprecationMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.comment());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Attribute)) {
            return false;
        }
        Attribute other = (Attribute)obj;
        return Objects.equals(this.fullyQualifiedName(), other.fullyQualifiedName()) && Objects.equals(this.dataTypeAsString(), other.dataTypeAsString()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.unit(), other.unit()) && this.hasAllowedValues() == other.hasAllowedValues() && Objects.equals(this.allowedValues(), other.allowedValues()) && Objects.equals(this.min(), other.min()) && Objects.equals(this.max(), other.max()) && Objects.equals(this.assignedValue(), other.assignedValue()) && Objects.equals(this.defaultValue(), other.defaultValue()) && Objects.equals(this.deprecationMessage(), other.deprecationMessage()) && Objects.equals(this.comment(), other.comment());
    }

    public final String toString() {
        return ToString.builder((String)"Attribute").add("FullyQualifiedName", (Object)this.fullyQualifiedName()).add("DataType", (Object)this.dataTypeAsString()).add("Description", (Object)this.description()).add("Unit", (Object)this.unit()).add("AllowedValues", this.hasAllowedValues() ? this.allowedValues() : null).add("Min", (Object)this.min()).add("Max", (Object)this.max()).add("AssignedValue", (Object)this.assignedValue()).add("DefaultValue", (Object)this.defaultValue()).add("DeprecationMessage", (Object)this.deprecationMessage()).add("Comment", (Object)this.comment()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "fullyQualifiedName": {
                return Optional.ofNullable(clazz.cast(this.fullyQualifiedName()));
            }
            case "dataType": {
                return Optional.ofNullable(clazz.cast(this.dataTypeAsString()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "unit": {
                return Optional.ofNullable(clazz.cast(this.unit()));
            }
            case "allowedValues": {
                return Optional.ofNullable(clazz.cast(this.allowedValues()));
            }
            case "min": {
                return Optional.ofNullable(clazz.cast(this.min()));
            }
            case "max": {
                return Optional.ofNullable(clazz.cast(this.max()));
            }
            case "assignedValue": {
                return Optional.ofNullable(clazz.cast(this.assignedValue()));
            }
            case "defaultValue": {
                return Optional.ofNullable(clazz.cast(this.defaultValue()));
            }
            case "deprecationMessage": {
                return Optional.ofNullable(clazz.cast(this.deprecationMessage()));
            }
            case "comment": {
                return Optional.ofNullable(clazz.cast(this.comment()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Attribute, T> g) {
        return obj -> g.apply((Attribute)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String fullyQualifiedName;
        private String dataType;
        private String description;
        private String unit;
        private List<String> allowedValues = DefaultSdkAutoConstructList.getInstance();
        private Double min;
        private Double max;
        private String assignedValue;
        private String defaultValue;
        private String deprecationMessage;
        private String comment;

        private BuilderImpl() {
        }

        private BuilderImpl(Attribute model) {
            this.fullyQualifiedName(model.fullyQualifiedName);
            this.dataType(model.dataType);
            this.description(model.description);
            this.unit(model.unit);
            this.allowedValues(model.allowedValues);
            this.min(model.min);
            this.max(model.max);
            this.assignedValue(model.assignedValue);
            this.defaultValue(model.defaultValue);
            this.deprecationMessage(model.deprecationMessage);
            this.comment(model.comment);
        }

        public final String getFullyQualifiedName() {
            return this.fullyQualifiedName;
        }

        public final void setFullyQualifiedName(String fullyQualifiedName) {
            this.fullyQualifiedName = fullyQualifiedName;
        }

        @Override
        public final Builder fullyQualifiedName(String fullyQualifiedName) {
            this.fullyQualifiedName = fullyQualifiedName;
            return this;
        }

        public final String getDataType() {
            return this.dataType;
        }

        public final void setDataType(String dataType) {
            this.dataType = dataType;
        }

        @Override
        public final Builder dataType(String dataType) {
            this.dataType = dataType;
            return this;
        }

        @Override
        public final Builder dataType(NodeDataType dataType) {
            this.dataType(dataType == null ? null : dataType.toString());
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getUnit() {
            return this.unit;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        public final Collection<String> getAllowedValues() {
            if (this.allowedValues instanceof SdkAutoConstructList) {
                return null;
            }
            return this.allowedValues;
        }

        public final void setAllowedValues(Collection<String> allowedValues) {
            this.allowedValues = _listOfStringsCopier.copy(allowedValues);
        }

        @Override
        public final Builder allowedValues(Collection<String> allowedValues) {
            this.allowedValues = _listOfStringsCopier.copy(allowedValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedValues(String ... allowedValues) {
            this.allowedValues(Arrays.asList(allowedValues));
            return this;
        }

        public final Double getMin() {
            return this.min;
        }

        public final void setMin(Double min) {
            this.min = min;
        }

        @Override
        public final Builder min(Double min) {
            this.min = min;
            return this;
        }

        public final Double getMax() {
            return this.max;
        }

        public final void setMax(Double max) {
            this.max = max;
        }

        @Override
        public final Builder max(Double max) {
            this.max = max;
            return this;
        }

        @Deprecated
        public final String getAssignedValue() {
            return this.assignedValue;
        }

        @Deprecated
        public final void setAssignedValue(String assignedValue) {
            this.assignedValue = assignedValue;
        }

        @Override
        @Deprecated
        public final Builder assignedValue(String assignedValue) {
            this.assignedValue = assignedValue;
            return this;
        }

        public final String getDefaultValue() {
            return this.defaultValue;
        }

        public final void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public final Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public final String getDeprecationMessage() {
            return this.deprecationMessage;
        }

        public final void setDeprecationMessage(String deprecationMessage) {
            this.deprecationMessage = deprecationMessage;
        }

        @Override
        public final Builder deprecationMessage(String deprecationMessage) {
            this.deprecationMessage = deprecationMessage;
            return this;
        }

        public final String getComment() {
            return this.comment;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public Attribute build() {
            return new Attribute(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Attribute> {
        public Builder fullyQualifiedName(String var1);

        public Builder dataType(String var1);

        public Builder dataType(NodeDataType var1);

        public Builder description(String var1);

        public Builder unit(String var1);

        public Builder allowedValues(Collection<String> var1);

        public Builder allowedValues(String ... var1);

        public Builder min(Double var1);

        public Builder max(Double var1);

        @Deprecated
        public Builder assignedValue(String var1);

        public Builder defaultValue(String var1);

        public Builder deprecationMessage(String var1);

        public Builder comment(String var1);
    }
}

