/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotfleetwise.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotfleetwise.IoTFleetWiseAsyncClient;
import software.amazon.awssdk.services.iotfleetwise.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotfleetwise.model.GetVehicleStatusRequest;
import software.amazon.awssdk.services.iotfleetwise.model.GetVehicleStatusResponse;
import software.amazon.awssdk.services.iotfleetwise.model.VehicleStatus;

public class GetVehicleStatusPublisher
implements SdkPublisher<GetVehicleStatusResponse> {
    private final IoTFleetWiseAsyncClient client;
    private final GetVehicleStatusRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetVehicleStatusPublisher(IoTFleetWiseAsyncClient client, GetVehicleStatusRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetVehicleStatusPublisher(IoTFleetWiseAsyncClient client, GetVehicleStatusRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetVehicleStatusResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetVehicleStatusResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<VehicleStatus> campaigns() {
        Function<GetVehicleStatusResponse, Iterator> getIterator = response -> {
            if (response != null && response.campaigns() != null) {
                return response.campaigns().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetVehicleStatusResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetVehicleStatusResponseFetcher
    implements AsyncPageFetcher<GetVehicleStatusResponse> {
        private GetVehicleStatusResponseFetcher() {
        }

        public boolean hasNextPage(GetVehicleStatusResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetVehicleStatusResponse> nextPage(GetVehicleStatusResponse previousPage) {
            if (previousPage == null) {
                return GetVehicleStatusPublisher.this.client.getVehicleStatus(GetVehicleStatusPublisher.this.firstRequest);
            }
            return GetVehicleStatusPublisher.this.client.getVehicleStatus((GetVehicleStatusRequest)((Object)GetVehicleStatusPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

