/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotfleetwise.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TriggerMode {
    ALWAYS("ALWAYS"),
    RISING_EDGE("RISING_EDGE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TriggerMode> VALUE_MAP;
    private final String value;

    private TriggerMode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TriggerMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TriggerMode> knownValues() {
        EnumSet<TriggerMode> knownValues = EnumSet.allOf(TriggerMode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TriggerMode.class, TriggerMode::toString);
    }
}

