/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotfleetwise.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DiagnosticsMode {
    OFF("OFF"),
    SEND_ACTIVE_DTCS("SEND_ACTIVE_DTCS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DiagnosticsMode> VALUE_MAP;
    private final String value;

    private DiagnosticsMode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DiagnosticsMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DiagnosticsMode> knownValues() {
        EnumSet<DiagnosticsMode> knownValues = EnumSet.allOf(DiagnosticsMode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DiagnosticsMode.class, DiagnosticsMode::toString);
    }
}

