/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotfleetwise.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotfleetwise.model.IoTFleetWiseRequest;
import software.amazon.awssdk.services.iotfleetwise.model.NetworkFileDefinition;
import software.amazon.awssdk.services.iotfleetwise.model.NetworkFileDefinitionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImportDecoderManifestRequest
extends IoTFleetWiseRequest
implements ToCopyableBuilder<Builder, ImportDecoderManifestRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(ImportDecoderManifestRequest.getter(ImportDecoderManifestRequest::name)).setter(ImportDecoderManifestRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<List<NetworkFileDefinition>> NETWORK_FILE_DEFINITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("networkFileDefinitions").getter(ImportDecoderManifestRequest.getter(ImportDecoderManifestRequest::networkFileDefinitions)).setter(ImportDecoderManifestRequest.setter(Builder::networkFileDefinitions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkFileDefinitions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NetworkFileDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, NETWORK_FILE_DEFINITIONS_FIELD));
    private final String name;
    private final List<NetworkFileDefinition> networkFileDefinitions;

    private ImportDecoderManifestRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.networkFileDefinitions = builder.networkFileDefinitions;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasNetworkFileDefinitions() {
        return this.networkFileDefinitions != null && !(this.networkFileDefinitions instanceof SdkAutoConstructList);
    }

    public final List<NetworkFileDefinition> networkFileDefinitions() {
        return this.networkFileDefinitions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNetworkFileDefinitions() ? this.networkFileDefinitions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportDecoderManifestRequest)) {
            return false;
        }
        ImportDecoderManifestRequest other = (ImportDecoderManifestRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && this.hasNetworkFileDefinitions() == other.hasNetworkFileDefinitions() && Objects.equals(this.networkFileDefinitions(), other.networkFileDefinitions());
    }

    public final String toString() {
        return ToString.builder((String)"ImportDecoderManifestRequest").add("Name", (Object)this.name()).add("NetworkFileDefinitions", this.hasNetworkFileDefinitions() ? this.networkFileDefinitions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "networkFileDefinitions": {
                return Optional.ofNullable(clazz.cast(this.networkFileDefinitions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImportDecoderManifestRequest, T> g) {
        return obj -> g.apply((ImportDecoderManifestRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTFleetWiseRequest.BuilderImpl
    implements Builder {
        private String name;
        private List<NetworkFileDefinition> networkFileDefinitions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ImportDecoderManifestRequest model) {
            super(model);
            this.name(model.name);
            this.networkFileDefinitions(model.networkFileDefinitions);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<NetworkFileDefinition.Builder> getNetworkFileDefinitions() {
            List<NetworkFileDefinition.Builder> result = NetworkFileDefinitionsCopier.copyToBuilder(this.networkFileDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNetworkFileDefinitions(Collection<NetworkFileDefinition.BuilderImpl> networkFileDefinitions) {
            this.networkFileDefinitions = NetworkFileDefinitionsCopier.copyFromBuilder(networkFileDefinitions);
        }

        @Override
        public final Builder networkFileDefinitions(Collection<NetworkFileDefinition> networkFileDefinitions) {
            this.networkFileDefinitions = NetworkFileDefinitionsCopier.copy(networkFileDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkFileDefinitions(NetworkFileDefinition ... networkFileDefinitions) {
            this.networkFileDefinitions(Arrays.asList(networkFileDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkFileDefinitions(Consumer<NetworkFileDefinition.Builder> ... networkFileDefinitions) {
            this.networkFileDefinitions(Stream.of(networkFileDefinitions).map(c -> (NetworkFileDefinition)((NetworkFileDefinition.Builder)NetworkFileDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ImportDecoderManifestRequest build() {
            return new ImportDecoderManifestRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IoTFleetWiseRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ImportDecoderManifestRequest> {
        public Builder name(String var1);

        public Builder networkFileDefinitions(Collection<NetworkFileDefinition> var1);

        public Builder networkFileDefinitions(NetworkFileDefinition ... var1);

        public Builder networkFileDefinitions(Consumer<NetworkFileDefinition.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

