/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotdeviceadvisor.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotdeviceadvisor.model.SuiteRunStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SuiteRunInformation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SuiteRunInformation> {
    private static final SdkField<String> SUITE_DEFINITION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("suiteDefinitionId").getter(SuiteRunInformation.getter(SuiteRunInformation::suiteDefinitionId)).setter(SuiteRunInformation.setter(Builder::suiteDefinitionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suiteDefinitionId").build()}).build();
    private static final SdkField<String> SUITE_DEFINITION_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("suiteDefinitionVersion").getter(SuiteRunInformation.getter(SuiteRunInformation::suiteDefinitionVersion)).setter(SuiteRunInformation.setter(Builder::suiteDefinitionVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suiteDefinitionVersion").build()}).build();
    private static final SdkField<String> SUITE_DEFINITION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("suiteDefinitionName").getter(SuiteRunInformation.getter(SuiteRunInformation::suiteDefinitionName)).setter(SuiteRunInformation.setter(Builder::suiteDefinitionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suiteDefinitionName").build()}).build();
    private static final SdkField<String> SUITE_RUN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("suiteRunId").getter(SuiteRunInformation.getter(SuiteRunInformation::suiteRunId)).setter(SuiteRunInformation.setter(Builder::suiteRunId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suiteRunId").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(SuiteRunInformation.getter(SuiteRunInformation::createdAt)).setter(SuiteRunInformation.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<Instant> STARTED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startedAt").getter(SuiteRunInformation.getter(SuiteRunInformation::startedAt)).setter(SuiteRunInformation.setter(Builder::startedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedAt").build()}).build();
    private static final SdkField<Instant> END_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endAt").getter(SuiteRunInformation.getter(SuiteRunInformation::endAt)).setter(SuiteRunInformation.setter(Builder::endAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endAt").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(SuiteRunInformation.getter(SuiteRunInformation::statusAsString)).setter(SuiteRunInformation.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Integer> PASSED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("passed").getter(SuiteRunInformation.getter(SuiteRunInformation::passed)).setter(SuiteRunInformation.setter(Builder::passed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("passed").build()}).build();
    private static final SdkField<Integer> FAILED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("failed").getter(SuiteRunInformation.getter(SuiteRunInformation::failed)).setter(SuiteRunInformation.setter(Builder::failed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failed").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUITE_DEFINITION_ID_FIELD, SUITE_DEFINITION_VERSION_FIELD, SUITE_DEFINITION_NAME_FIELD, SUITE_RUN_ID_FIELD, CREATED_AT_FIELD, STARTED_AT_FIELD, END_AT_FIELD, STATUS_FIELD, PASSED_FIELD, FAILED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SuiteRunInformation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String suiteDefinitionId;
    private final String suiteDefinitionVersion;
    private final String suiteDefinitionName;
    private final String suiteRunId;
    private final Instant createdAt;
    private final Instant startedAt;
    private final Instant endAt;
    private final String status;
    private final Integer passed;
    private final Integer failed;

    private SuiteRunInformation(BuilderImpl builder) {
        this.suiteDefinitionId = builder.suiteDefinitionId;
        this.suiteDefinitionVersion = builder.suiteDefinitionVersion;
        this.suiteDefinitionName = builder.suiteDefinitionName;
        this.suiteRunId = builder.suiteRunId;
        this.createdAt = builder.createdAt;
        this.startedAt = builder.startedAt;
        this.endAt = builder.endAt;
        this.status = builder.status;
        this.passed = builder.passed;
        this.failed = builder.failed;
    }

    public final String suiteDefinitionId() {
        return this.suiteDefinitionId;
    }

    public final String suiteDefinitionVersion() {
        return this.suiteDefinitionVersion;
    }

    public final String suiteDefinitionName() {
        return this.suiteDefinitionName;
    }

    public final String suiteRunId() {
        return this.suiteRunId;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant startedAt() {
        return this.startedAt;
    }

    public final Instant endAt() {
        return this.endAt;
    }

    public final SuiteRunStatus status() {
        return SuiteRunStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Integer passed() {
        return this.passed;
    }

    public final Integer failed() {
        return this.failed;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.suiteDefinitionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.suiteDefinitionVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.suiteDefinitionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.suiteRunId());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.endAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.passed());
        hashCode = 31 * hashCode + Objects.hashCode(this.failed());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SuiteRunInformation)) {
            return false;
        }
        SuiteRunInformation other = (SuiteRunInformation)obj;
        return Objects.equals(this.suiteDefinitionId(), other.suiteDefinitionId()) && Objects.equals(this.suiteDefinitionVersion(), other.suiteDefinitionVersion()) && Objects.equals(this.suiteDefinitionName(), other.suiteDefinitionName()) && Objects.equals(this.suiteRunId(), other.suiteRunId()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.startedAt(), other.startedAt()) && Objects.equals(this.endAt(), other.endAt()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.passed(), other.passed()) && Objects.equals(this.failed(), other.failed());
    }

    public final String toString() {
        return ToString.builder((String)"SuiteRunInformation").add("SuiteDefinitionId", (Object)this.suiteDefinitionId()).add("SuiteDefinitionVersion", (Object)this.suiteDefinitionVersion()).add("SuiteDefinitionName", (Object)this.suiteDefinitionName()).add("SuiteRunId", (Object)this.suiteRunId()).add("CreatedAt", (Object)this.createdAt()).add("StartedAt", (Object)this.startedAt()).add("EndAt", (Object)this.endAt()).add("Status", (Object)this.statusAsString()).add("Passed", (Object)this.passed()).add("Failed", (Object)this.failed()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "suiteDefinitionId": {
                return Optional.ofNullable(clazz.cast(this.suiteDefinitionId()));
            }
            case "suiteDefinitionVersion": {
                return Optional.ofNullable(clazz.cast(this.suiteDefinitionVersion()));
            }
            case "suiteDefinitionName": {
                return Optional.ofNullable(clazz.cast(this.suiteDefinitionName()));
            }
            case "suiteRunId": {
                return Optional.ofNullable(clazz.cast(this.suiteRunId()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "startedAt": {
                return Optional.ofNullable(clazz.cast(this.startedAt()));
            }
            case "endAt": {
                return Optional.ofNullable(clazz.cast(this.endAt()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "passed": {
                return Optional.ofNullable(clazz.cast(this.passed()));
            }
            case "failed": {
                return Optional.ofNullable(clazz.cast(this.failed()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("suiteDefinitionId", SUITE_DEFINITION_ID_FIELD);
        map.put("suiteDefinitionVersion", SUITE_DEFINITION_VERSION_FIELD);
        map.put("suiteDefinitionName", SUITE_DEFINITION_NAME_FIELD);
        map.put("suiteRunId", SUITE_RUN_ID_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("startedAt", STARTED_AT_FIELD);
        map.put("endAt", END_AT_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("passed", PASSED_FIELD);
        map.put("failed", FAILED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SuiteRunInformation, T> g) {
        return obj -> g.apply((SuiteRunInformation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String suiteDefinitionId;
        private String suiteDefinitionVersion;
        private String suiteDefinitionName;
        private String suiteRunId;
        private Instant createdAt;
        private Instant startedAt;
        private Instant endAt;
        private String status;
        private Integer passed;
        private Integer failed;

        private BuilderImpl() {
        }

        private BuilderImpl(SuiteRunInformation model) {
            this.suiteDefinitionId(model.suiteDefinitionId);
            this.suiteDefinitionVersion(model.suiteDefinitionVersion);
            this.suiteDefinitionName(model.suiteDefinitionName);
            this.suiteRunId(model.suiteRunId);
            this.createdAt(model.createdAt);
            this.startedAt(model.startedAt);
            this.endAt(model.endAt);
            this.status(model.status);
            this.passed(model.passed);
            this.failed(model.failed);
        }

        public final String getSuiteDefinitionId() {
            return this.suiteDefinitionId;
        }

        public final void setSuiteDefinitionId(String suiteDefinitionId) {
            this.suiteDefinitionId = suiteDefinitionId;
        }

        @Override
        public final Builder suiteDefinitionId(String suiteDefinitionId) {
            this.suiteDefinitionId = suiteDefinitionId;
            return this;
        }

        public final String getSuiteDefinitionVersion() {
            return this.suiteDefinitionVersion;
        }

        public final void setSuiteDefinitionVersion(String suiteDefinitionVersion) {
            this.suiteDefinitionVersion = suiteDefinitionVersion;
        }

        @Override
        public final Builder suiteDefinitionVersion(String suiteDefinitionVersion) {
            this.suiteDefinitionVersion = suiteDefinitionVersion;
            return this;
        }

        public final String getSuiteDefinitionName() {
            return this.suiteDefinitionName;
        }

        public final void setSuiteDefinitionName(String suiteDefinitionName) {
            this.suiteDefinitionName = suiteDefinitionName;
        }

        @Override
        public final Builder suiteDefinitionName(String suiteDefinitionName) {
            this.suiteDefinitionName = suiteDefinitionName;
            return this;
        }

        public final String getSuiteRunId() {
            return this.suiteRunId;
        }

        public final void setSuiteRunId(String suiteRunId) {
            this.suiteRunId = suiteRunId;
        }

        @Override
        public final Builder suiteRunId(String suiteRunId) {
            this.suiteRunId = suiteRunId;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getStartedAt() {
            return this.startedAt;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final Instant getEndAt() {
            return this.endAt;
        }

        public final void setEndAt(Instant endAt) {
            this.endAt = endAt;
        }

        @Override
        public final Builder endAt(Instant endAt) {
            this.endAt = endAt;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SuiteRunStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Integer getPassed() {
            return this.passed;
        }

        public final void setPassed(Integer passed) {
            this.passed = passed;
        }

        @Override
        public final Builder passed(Integer passed) {
            this.passed = passed;
            return this;
        }

        public final Integer getFailed() {
            return this.failed;
        }

        public final void setFailed(Integer failed) {
            this.failed = failed;
        }

        @Override
        public final Builder failed(Integer failed) {
            this.failed = failed;
            return this;
        }

        public SuiteRunInformation build() {
            return new SuiteRunInformation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SuiteRunInformation> {
        public Builder suiteDefinitionId(String var1);

        public Builder suiteDefinitionVersion(String var1);

        public Builder suiteDefinitionName(String var1);

        public Builder suiteRunId(String var1);

        public Builder createdAt(Instant var1);

        public Builder startedAt(Instant var1);

        public Builder endAt(Instant var1);

        public Builder status(String var1);

        public Builder status(SuiteRunStatus var1);

        public Builder passed(Integer var1);

        public Builder failed(Integer var1);
    }
}

