/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotdeviceadvisor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotdeviceadvisor.model.TestCaseRun;
import software.amazon.awssdk.services.iotdeviceadvisor.model.TestCaseRunsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GroupResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GroupResult> {
    private static final SdkField<String> GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("groupId").getter(GroupResult.getter(GroupResult::groupId)).setter(GroupResult.setter(Builder::groupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupId").build()}).build();
    private static final SdkField<String> GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("groupName").getter(GroupResult.getter(GroupResult::groupName)).setter(GroupResult.setter(Builder::groupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupName").build()}).build();
    private static final SdkField<List<TestCaseRun>> TESTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tests").getter(GroupResult.getter(GroupResult::tests)).setter(GroupResult.setter(Builder::tests)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tests").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TestCaseRun::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_ID_FIELD, GROUP_NAME_FIELD, TESTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("groupId", GROUP_ID_FIELD);
            this.put("groupName", GROUP_NAME_FIELD);
            this.put("tests", TESTS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String groupId;
    private final String groupName;
    private final List<TestCaseRun> tests;

    private GroupResult(BuilderImpl builder) {
        this.groupId = builder.groupId;
        this.groupName = builder.groupName;
        this.tests = builder.tests;
    }

    public final String groupId() {
        return this.groupId;
    }

    public final String groupName() {
        return this.groupName;
    }

    public final boolean hasTests() {
        return this.tests != null && !(this.tests instanceof SdkAutoConstructList);
    }

    public final List<TestCaseRun> tests() {
        return this.tests;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.groupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTests() ? this.tests() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GroupResult)) {
            return false;
        }
        GroupResult other = (GroupResult)obj;
        return Objects.equals(this.groupId(), other.groupId()) && Objects.equals(this.groupName(), other.groupName()) && this.hasTests() == other.hasTests() && Objects.equals(this.tests(), other.tests());
    }

    public final String toString() {
        return ToString.builder((String)"GroupResult").add("GroupId", (Object)this.groupId()).add("GroupName", (Object)this.groupName()).add("Tests", this.hasTests() ? this.tests() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "groupId": {
                return Optional.ofNullable(clazz.cast(this.groupId()));
            }
            case "groupName": {
                return Optional.ofNullable(clazz.cast(this.groupName()));
            }
            case "tests": {
                return Optional.ofNullable(clazz.cast(this.tests()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GroupResult, T> g) {
        return obj -> g.apply((GroupResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String groupId;
        private String groupName;
        private List<TestCaseRun> tests = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GroupResult model) {
            this.groupId(model.groupId);
            this.groupName(model.groupName);
            this.tests(model.tests);
        }

        public final String getGroupId() {
            return this.groupId;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final String getGroupName() {
            return this.groupName;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final List<TestCaseRun.Builder> getTests() {
            List<TestCaseRun.Builder> result = TestCaseRunsCopier.copyToBuilder(this.tests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTests(Collection<TestCaseRun.BuilderImpl> tests) {
            this.tests = TestCaseRunsCopier.copyFromBuilder(tests);
        }

        @Override
        public final Builder tests(Collection<TestCaseRun> tests) {
            this.tests = TestCaseRunsCopier.copy(tests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tests(TestCaseRun ... tests) {
            this.tests(Arrays.asList(tests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tests(Consumer<TestCaseRun.Builder> ... tests) {
            this.tests(Stream.of(tests).map(c -> (TestCaseRun)((TestCaseRun.Builder)TestCaseRun.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public GroupResult build() {
            return new GroupResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GroupResult> {
        public Builder groupId(String var1);

        public Builder groupName(String var1);

        public Builder tests(Collection<TestCaseRun> var1);

        public Builder tests(TestCaseRun ... var1);

        public Builder tests(Consumer<TestCaseRun.Builder> ... var1);
    }
}

