/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotdeviceadvisor.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotdeviceadvisor.model.AuthenticationMethod;
import software.amazon.awssdk.services.iotdeviceadvisor.model.IotDeviceAdvisorRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetEndpointRequest
extends IotDeviceAdvisorRequest
implements ToCopyableBuilder<Builder, GetEndpointRequest> {
    private static final SdkField<String> THING_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("thingArn").getter(GetEndpointRequest.getter(GetEndpointRequest::thingArn)).setter(GetEndpointRequest.setter(Builder::thingArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("thingArn").build()}).build();
    private static final SdkField<String> CERTIFICATE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("certificateArn").getter(GetEndpointRequest.getter(GetEndpointRequest::certificateArn)).setter(GetEndpointRequest.setter(Builder::certificateArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("certificateArn").build()}).build();
    private static final SdkField<String> DEVICE_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deviceRoleArn").getter(GetEndpointRequest.getter(GetEndpointRequest::deviceRoleArn)).setter(GetEndpointRequest.setter(Builder::deviceRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("deviceRoleArn").build()}).build();
    private static final SdkField<String> AUTHENTICATION_METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("authenticationMethod").getter(GetEndpointRequest.getter(GetEndpointRequest::authenticationMethodAsString)).setter(GetEndpointRequest.setter(Builder::authenticationMethod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("authenticationMethod").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THING_ARN_FIELD, CERTIFICATE_ARN_FIELD, DEVICE_ROLE_ARN_FIELD, AUTHENTICATION_METHOD_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("thingArn", THING_ARN_FIELD);
            this.put("certificateArn", CERTIFICATE_ARN_FIELD);
            this.put("deviceRoleArn", DEVICE_ROLE_ARN_FIELD);
            this.put("authenticationMethod", AUTHENTICATION_METHOD_FIELD);
        }
    });
    private final String thingArn;
    private final String certificateArn;
    private final String deviceRoleArn;
    private final String authenticationMethod;

    private GetEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.thingArn = builder.thingArn;
        this.certificateArn = builder.certificateArn;
        this.deviceRoleArn = builder.deviceRoleArn;
        this.authenticationMethod = builder.authenticationMethod;
    }

    public final String thingArn() {
        return this.thingArn;
    }

    public final String certificateArn() {
        return this.certificateArn;
    }

    public final String deviceRoleArn() {
        return this.deviceRoleArn;
    }

    public final AuthenticationMethod authenticationMethod() {
        return AuthenticationMethod.fromValue(this.authenticationMethod);
    }

    public final String authenticationMethodAsString() {
        return this.authenticationMethod;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.thingArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationMethodAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEndpointRequest)) {
            return false;
        }
        GetEndpointRequest other = (GetEndpointRequest)((Object)obj);
        return Objects.equals(this.thingArn(), other.thingArn()) && Objects.equals(this.certificateArn(), other.certificateArn()) && Objects.equals(this.deviceRoleArn(), other.deviceRoleArn()) && Objects.equals(this.authenticationMethodAsString(), other.authenticationMethodAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetEndpointRequest").add("ThingArn", (Object)this.thingArn()).add("CertificateArn", (Object)this.certificateArn()).add("DeviceRoleArn", (Object)this.deviceRoleArn()).add("AuthenticationMethod", (Object)this.authenticationMethodAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "thingArn": {
                return Optional.ofNullable(clazz.cast(this.thingArn()));
            }
            case "certificateArn": {
                return Optional.ofNullable(clazz.cast(this.certificateArn()));
            }
            case "deviceRoleArn": {
                return Optional.ofNullable(clazz.cast(this.deviceRoleArn()));
            }
            case "authenticationMethod": {
                return Optional.ofNullable(clazz.cast(this.authenticationMethodAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetEndpointRequest, T> g) {
        return obj -> g.apply((GetEndpointRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotDeviceAdvisorRequest.BuilderImpl
    implements Builder {
        private String thingArn;
        private String certificateArn;
        private String deviceRoleArn;
        private String authenticationMethod;

        private BuilderImpl() {
        }

        private BuilderImpl(GetEndpointRequest model) {
            super(model);
            this.thingArn(model.thingArn);
            this.certificateArn(model.certificateArn);
            this.deviceRoleArn(model.deviceRoleArn);
            this.authenticationMethod(model.authenticationMethod);
        }

        public final String getThingArn() {
            return this.thingArn;
        }

        public final void setThingArn(String thingArn) {
            this.thingArn = thingArn;
        }

        @Override
        public final Builder thingArn(String thingArn) {
            this.thingArn = thingArn;
            return this;
        }

        public final String getCertificateArn() {
            return this.certificateArn;
        }

        public final void setCertificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
        }

        @Override
        public final Builder certificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
            return this;
        }

        public final String getDeviceRoleArn() {
            return this.deviceRoleArn;
        }

        public final void setDeviceRoleArn(String deviceRoleArn) {
            this.deviceRoleArn = deviceRoleArn;
        }

        @Override
        public final Builder deviceRoleArn(String deviceRoleArn) {
            this.deviceRoleArn = deviceRoleArn;
            return this;
        }

        public final String getAuthenticationMethod() {
            return this.authenticationMethod;
        }

        public final void setAuthenticationMethod(String authenticationMethod) {
            this.authenticationMethod = authenticationMethod;
        }

        @Override
        public final Builder authenticationMethod(String authenticationMethod) {
            this.authenticationMethod = authenticationMethod;
            return this;
        }

        @Override
        public final Builder authenticationMethod(AuthenticationMethod authenticationMethod) {
            this.authenticationMethod(authenticationMethod == null ? null : authenticationMethod.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetEndpointRequest build() {
            return new GetEndpointRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IotDeviceAdvisorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetEndpointRequest> {
        public Builder thingArn(String var1);

        public Builder certificateArn(String var1);

        public Builder deviceRoleArn(String var1);

        public Builder authenticationMethod(String var1);

        public Builder authenticationMethod(AuthenticationMethod var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

