/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotdeviceadvisor.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotdeviceadvisor.model.IotDeviceAdvisorResponse;
import software.amazon.awssdk.services.iotdeviceadvisor.model.SuiteRunInformation;
import software.amazon.awssdk.services.iotdeviceadvisor.model.SuiteRunsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSuiteRunsResponse
extends IotDeviceAdvisorResponse
implements ToCopyableBuilder<Builder, ListSuiteRunsResponse> {
    private static final SdkField<List<SuiteRunInformation>> SUITE_RUNS_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("suiteRunsList").getter(ListSuiteRunsResponse.getter(ListSuiteRunsResponse::suiteRunsList)).setter(ListSuiteRunsResponse.setter(Builder::suiteRunsList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suiteRunsList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SuiteRunInformation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListSuiteRunsResponse.getter(ListSuiteRunsResponse::nextToken)).setter(ListSuiteRunsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUITE_RUNS_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final List<SuiteRunInformation> suiteRunsList;
    private final String nextToken;

    private ListSuiteRunsResponse(BuilderImpl builder) {
        super(builder);
        this.suiteRunsList = builder.suiteRunsList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasSuiteRunsList() {
        return this.suiteRunsList != null && !(this.suiteRunsList instanceof SdkAutoConstructList);
    }

    public final List<SuiteRunInformation> suiteRunsList() {
        return this.suiteRunsList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSuiteRunsList() ? this.suiteRunsList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSuiteRunsResponse)) {
            return false;
        }
        ListSuiteRunsResponse other = (ListSuiteRunsResponse)((Object)obj);
        return this.hasSuiteRunsList() == other.hasSuiteRunsList() && Objects.equals(this.suiteRunsList(), other.suiteRunsList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListSuiteRunsResponse").add("SuiteRunsList", this.hasSuiteRunsList() ? this.suiteRunsList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "suiteRunsList": {
                return Optional.ofNullable(clazz.cast(this.suiteRunsList()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSuiteRunsResponse, T> g) {
        return obj -> g.apply((ListSuiteRunsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotDeviceAdvisorResponse.BuilderImpl
    implements Builder {
        private List<SuiteRunInformation> suiteRunsList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSuiteRunsResponse model) {
            super(model);
            this.suiteRunsList(model.suiteRunsList);
            this.nextToken(model.nextToken);
        }

        public final List<SuiteRunInformation.Builder> getSuiteRunsList() {
            List<SuiteRunInformation.Builder> result = SuiteRunsListCopier.copyToBuilder(this.suiteRunsList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSuiteRunsList(Collection<SuiteRunInformation.BuilderImpl> suiteRunsList) {
            this.suiteRunsList = SuiteRunsListCopier.copyFromBuilder(suiteRunsList);
        }

        @Override
        public final Builder suiteRunsList(Collection<SuiteRunInformation> suiteRunsList) {
            this.suiteRunsList = SuiteRunsListCopier.copy(suiteRunsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder suiteRunsList(SuiteRunInformation ... suiteRunsList) {
            this.suiteRunsList(Arrays.asList(suiteRunsList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder suiteRunsList(Consumer<SuiteRunInformation.Builder> ... suiteRunsList) {
            this.suiteRunsList(Stream.of(suiteRunsList).map(c -> (SuiteRunInformation)((SuiteRunInformation.Builder)SuiteRunInformation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListSuiteRunsResponse build() {
            return new ListSuiteRunsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotDeviceAdvisorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSuiteRunsResponse> {
        public Builder suiteRunsList(Collection<SuiteRunInformation> var1);

        public Builder suiteRunsList(SuiteRunInformation ... var1);

        public Builder suiteRunsList(Consumer<SuiteRunInformation.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

