/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotdeviceadvisor.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotdeviceadvisor.IotDeviceAdvisorClient;
import software.amazon.awssdk.services.iotdeviceadvisor.model.ListSuiteRunsRequest;
import software.amazon.awssdk.services.iotdeviceadvisor.model.ListSuiteRunsResponse;

public class ListSuiteRunsIterable
implements SdkIterable<ListSuiteRunsResponse> {
    private final IotDeviceAdvisorClient client;
    private final ListSuiteRunsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSuiteRunsIterable(IotDeviceAdvisorClient client, ListSuiteRunsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListSuiteRunsResponseFetcher();
    }

    public Iterator<ListSuiteRunsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListSuiteRunsResponseFetcher
    implements SyncPageFetcher<ListSuiteRunsResponse> {
        private ListSuiteRunsResponseFetcher() {
        }

        public boolean hasNextPage(ListSuiteRunsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSuiteRunsResponse nextPage(ListSuiteRunsResponse previousPage) {
            if (previousPage == null) {
                return ListSuiteRunsIterable.this.client.listSuiteRuns(ListSuiteRunsIterable.this.firstRequest);
            }
            return ListSuiteRunsIterable.this.client.listSuiteRuns((ListSuiteRunsRequest)((Object)ListSuiteRunsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

