/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotdeviceadvisor.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotdeviceadvisor.model.DeviceUnderTest;
import software.amazon.awssdk.services.iotdeviceadvisor.model.DeviceUnderTestListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SuiteDefinitionInformation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SuiteDefinitionInformation> {
    private static final SdkField<String> SUITE_DEFINITION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("suiteDefinitionId").getter(SuiteDefinitionInformation.getter(SuiteDefinitionInformation::suiteDefinitionId)).setter(SuiteDefinitionInformation.setter(Builder::suiteDefinitionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suiteDefinitionId").build()}).build();
    private static final SdkField<String> SUITE_DEFINITION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("suiteDefinitionName").getter(SuiteDefinitionInformation.getter(SuiteDefinitionInformation::suiteDefinitionName)).setter(SuiteDefinitionInformation.setter(Builder::suiteDefinitionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suiteDefinitionName").build()}).build();
    private static final SdkField<List<DeviceUnderTest>> DEFAULT_DEVICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("defaultDevices").getter(SuiteDefinitionInformation.getter(SuiteDefinitionInformation::defaultDevices)).setter(SuiteDefinitionInformation.setter(Builder::defaultDevices)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultDevices").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DeviceUnderTest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> INTENDED_FOR_QUALIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("intendedForQualification").getter(SuiteDefinitionInformation.getter(SuiteDefinitionInformation::intendedForQualification)).setter(SuiteDefinitionInformation.setter(Builder::intendedForQualification)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intendedForQualification").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(SuiteDefinitionInformation.getter(SuiteDefinitionInformation::createdAt)).setter(SuiteDefinitionInformation.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUITE_DEFINITION_ID_FIELD, SUITE_DEFINITION_NAME_FIELD, DEFAULT_DEVICES_FIELD, INTENDED_FOR_QUALIFICATION_FIELD, CREATED_AT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String suiteDefinitionId;
    private final String suiteDefinitionName;
    private final List<DeviceUnderTest> defaultDevices;
    private final Boolean intendedForQualification;
    private final Instant createdAt;

    private SuiteDefinitionInformation(BuilderImpl builder) {
        this.suiteDefinitionId = builder.suiteDefinitionId;
        this.suiteDefinitionName = builder.suiteDefinitionName;
        this.defaultDevices = builder.defaultDevices;
        this.intendedForQualification = builder.intendedForQualification;
        this.createdAt = builder.createdAt;
    }

    public final String suiteDefinitionId() {
        return this.suiteDefinitionId;
    }

    public final String suiteDefinitionName() {
        return this.suiteDefinitionName;
    }

    public final boolean hasDefaultDevices() {
        return this.defaultDevices != null && !(this.defaultDevices instanceof SdkAutoConstructList);
    }

    public final List<DeviceUnderTest> defaultDevices() {
        return this.defaultDevices;
    }

    public final Boolean intendedForQualification() {
        return this.intendedForQualification;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.suiteDefinitionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.suiteDefinitionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDefaultDevices() ? this.defaultDevices() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.intendedForQualification());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SuiteDefinitionInformation)) {
            return false;
        }
        SuiteDefinitionInformation other = (SuiteDefinitionInformation)obj;
        return Objects.equals(this.suiteDefinitionId(), other.suiteDefinitionId()) && Objects.equals(this.suiteDefinitionName(), other.suiteDefinitionName()) && this.hasDefaultDevices() == other.hasDefaultDevices() && Objects.equals(this.defaultDevices(), other.defaultDevices()) && Objects.equals(this.intendedForQualification(), other.intendedForQualification()) && Objects.equals(this.createdAt(), other.createdAt());
    }

    public final String toString() {
        return ToString.builder((String)"SuiteDefinitionInformation").add("SuiteDefinitionId", (Object)this.suiteDefinitionId()).add("SuiteDefinitionName", (Object)this.suiteDefinitionName()).add("DefaultDevices", this.hasDefaultDevices() ? this.defaultDevices() : null).add("IntendedForQualification", (Object)this.intendedForQualification()).add("CreatedAt", (Object)this.createdAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "suiteDefinitionId": {
                return Optional.ofNullable(clazz.cast(this.suiteDefinitionId()));
            }
            case "suiteDefinitionName": {
                return Optional.ofNullable(clazz.cast(this.suiteDefinitionName()));
            }
            case "defaultDevices": {
                return Optional.ofNullable(clazz.cast(this.defaultDevices()));
            }
            case "intendedForQualification": {
                return Optional.ofNullable(clazz.cast(this.intendedForQualification()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SuiteDefinitionInformation, T> g) {
        return obj -> g.apply((SuiteDefinitionInformation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String suiteDefinitionId;
        private String suiteDefinitionName;
        private List<DeviceUnderTest> defaultDevices = DefaultSdkAutoConstructList.getInstance();
        private Boolean intendedForQualification;
        private Instant createdAt;

        private BuilderImpl() {
        }

        private BuilderImpl(SuiteDefinitionInformation model) {
            this.suiteDefinitionId(model.suiteDefinitionId);
            this.suiteDefinitionName(model.suiteDefinitionName);
            this.defaultDevices(model.defaultDevices);
            this.intendedForQualification(model.intendedForQualification);
            this.createdAt(model.createdAt);
        }

        public final String getSuiteDefinitionId() {
            return this.suiteDefinitionId;
        }

        public final void setSuiteDefinitionId(String suiteDefinitionId) {
            this.suiteDefinitionId = suiteDefinitionId;
        }

        @Override
        @Transient
        public final Builder suiteDefinitionId(String suiteDefinitionId) {
            this.suiteDefinitionId = suiteDefinitionId;
            return this;
        }

        public final String getSuiteDefinitionName() {
            return this.suiteDefinitionName;
        }

        public final void setSuiteDefinitionName(String suiteDefinitionName) {
            this.suiteDefinitionName = suiteDefinitionName;
        }

        @Override
        @Transient
        public final Builder suiteDefinitionName(String suiteDefinitionName) {
            this.suiteDefinitionName = suiteDefinitionName;
            return this;
        }

        public final List<DeviceUnderTest.Builder> getDefaultDevices() {
            List<DeviceUnderTest.Builder> result = DeviceUnderTestListCopier.copyToBuilder(this.defaultDevices);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDefaultDevices(Collection<DeviceUnderTest.BuilderImpl> defaultDevices) {
            this.defaultDevices = DeviceUnderTestListCopier.copyFromBuilder(defaultDevices);
        }

        @Override
        @Transient
        public final Builder defaultDevices(Collection<DeviceUnderTest> defaultDevices) {
            this.defaultDevices = DeviceUnderTestListCopier.copy(defaultDevices);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder defaultDevices(DeviceUnderTest ... defaultDevices) {
            this.defaultDevices(Arrays.asList(defaultDevices));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder defaultDevices(Consumer<DeviceUnderTest.Builder> ... defaultDevices) {
            this.defaultDevices(Stream.of(defaultDevices).map(c -> (DeviceUnderTest)((DeviceUnderTest.Builder)DeviceUnderTest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getIntendedForQualification() {
            return this.intendedForQualification;
        }

        public final void setIntendedForQualification(Boolean intendedForQualification) {
            this.intendedForQualification = intendedForQualification;
        }

        @Override
        @Transient
        public final Builder intendedForQualification(Boolean intendedForQualification) {
            this.intendedForQualification = intendedForQualification;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        @Transient
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public SuiteDefinitionInformation build() {
            return new SuiteDefinitionInformation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SuiteDefinitionInformation> {
        public Builder suiteDefinitionId(String var1);

        public Builder suiteDefinitionName(String var1);

        public Builder defaultDevices(Collection<DeviceUnderTest> var1);

        public Builder defaultDevices(DeviceUnderTest ... var1);

        public Builder defaultDevices(Consumer<DeviceUnderTest.Builder> ... var1);

        public Builder intendedForQualification(Boolean var1);

        public Builder createdAt(Instant var1);
    }
}

