/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotdeviceadvisor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotdeviceadvisor.model.DeviceUnderTest;
import software.amazon.awssdk.services.iotdeviceadvisor.model.DeviceUnderTestListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SuiteDefinitionConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SuiteDefinitionConfiguration> {
    private static final SdkField<String> SUITE_DEFINITION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("suiteDefinitionName").getter(SuiteDefinitionConfiguration.getter(SuiteDefinitionConfiguration::suiteDefinitionName)).setter(SuiteDefinitionConfiguration.setter(Builder::suiteDefinitionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suiteDefinitionName").build()}).build();
    private static final SdkField<List<DeviceUnderTest>> DEVICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("devices").getter(SuiteDefinitionConfiguration.getter(SuiteDefinitionConfiguration::devices)).setter(SuiteDefinitionConfiguration.setter(Builder::devices)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("devices").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DeviceUnderTest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> INTENDED_FOR_QUALIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("intendedForQualification").getter(SuiteDefinitionConfiguration.getter(SuiteDefinitionConfiguration::intendedForQualification)).setter(SuiteDefinitionConfiguration.setter(Builder::intendedForQualification)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intendedForQualification").build()}).build();
    private static final SdkField<String> ROOT_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("rootGroup").getter(SuiteDefinitionConfiguration.getter(SuiteDefinitionConfiguration::rootGroup)).setter(SuiteDefinitionConfiguration.setter(Builder::rootGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rootGroup").build()}).build();
    private static final SdkField<String> DEVICE_PERMISSION_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("devicePermissionRoleArn").getter(SuiteDefinitionConfiguration.getter(SuiteDefinitionConfiguration::devicePermissionRoleArn)).setter(SuiteDefinitionConfiguration.setter(Builder::devicePermissionRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("devicePermissionRoleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUITE_DEFINITION_NAME_FIELD, DEVICES_FIELD, INTENDED_FOR_QUALIFICATION_FIELD, ROOT_GROUP_FIELD, DEVICE_PERMISSION_ROLE_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String suiteDefinitionName;
    private final List<DeviceUnderTest> devices;
    private final Boolean intendedForQualification;
    private final String rootGroup;
    private final String devicePermissionRoleArn;

    private SuiteDefinitionConfiguration(BuilderImpl builder) {
        this.suiteDefinitionName = builder.suiteDefinitionName;
        this.devices = builder.devices;
        this.intendedForQualification = builder.intendedForQualification;
        this.rootGroup = builder.rootGroup;
        this.devicePermissionRoleArn = builder.devicePermissionRoleArn;
    }

    public final String suiteDefinitionName() {
        return this.suiteDefinitionName;
    }

    public final boolean hasDevices() {
        return this.devices != null && !(this.devices instanceof SdkAutoConstructList);
    }

    public final List<DeviceUnderTest> devices() {
        return this.devices;
    }

    public final Boolean intendedForQualification() {
        return this.intendedForQualification;
    }

    public final String rootGroup() {
        return this.rootGroup;
    }

    public final String devicePermissionRoleArn() {
        return this.devicePermissionRoleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.suiteDefinitionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDevices() ? this.devices() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.intendedForQualification());
        hashCode = 31 * hashCode + Objects.hashCode(this.rootGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.devicePermissionRoleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SuiteDefinitionConfiguration)) {
            return false;
        }
        SuiteDefinitionConfiguration other = (SuiteDefinitionConfiguration)obj;
        return Objects.equals(this.suiteDefinitionName(), other.suiteDefinitionName()) && this.hasDevices() == other.hasDevices() && Objects.equals(this.devices(), other.devices()) && Objects.equals(this.intendedForQualification(), other.intendedForQualification()) && Objects.equals(this.rootGroup(), other.rootGroup()) && Objects.equals(this.devicePermissionRoleArn(), other.devicePermissionRoleArn());
    }

    public final String toString() {
        return ToString.builder((String)"SuiteDefinitionConfiguration").add("SuiteDefinitionName", (Object)this.suiteDefinitionName()).add("Devices", this.hasDevices() ? this.devices() : null).add("IntendedForQualification", (Object)this.intendedForQualification()).add("RootGroup", (Object)this.rootGroup()).add("DevicePermissionRoleArn", (Object)this.devicePermissionRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "suiteDefinitionName": {
                return Optional.ofNullable(clazz.cast(this.suiteDefinitionName()));
            }
            case "devices": {
                return Optional.ofNullable(clazz.cast(this.devices()));
            }
            case "intendedForQualification": {
                return Optional.ofNullable(clazz.cast(this.intendedForQualification()));
            }
            case "rootGroup": {
                return Optional.ofNullable(clazz.cast(this.rootGroup()));
            }
            case "devicePermissionRoleArn": {
                return Optional.ofNullable(clazz.cast(this.devicePermissionRoleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SuiteDefinitionConfiguration, T> g) {
        return obj -> g.apply((SuiteDefinitionConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String suiteDefinitionName;
        private List<DeviceUnderTest> devices = DefaultSdkAutoConstructList.getInstance();
        private Boolean intendedForQualification;
        private String rootGroup;
        private String devicePermissionRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(SuiteDefinitionConfiguration model) {
            this.suiteDefinitionName(model.suiteDefinitionName);
            this.devices(model.devices);
            this.intendedForQualification(model.intendedForQualification);
            this.rootGroup(model.rootGroup);
            this.devicePermissionRoleArn(model.devicePermissionRoleArn);
        }

        public final String getSuiteDefinitionName() {
            return this.suiteDefinitionName;
        }

        @Override
        public final Builder suiteDefinitionName(String suiteDefinitionName) {
            this.suiteDefinitionName = suiteDefinitionName;
            return this;
        }

        public final void setSuiteDefinitionName(String suiteDefinitionName) {
            this.suiteDefinitionName = suiteDefinitionName;
        }

        public final Collection<DeviceUnderTest.Builder> getDevices() {
            if (this.devices instanceof SdkAutoConstructList) {
                return null;
            }
            return this.devices != null ? (Collection)this.devices.stream().map(DeviceUnderTest::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder devices(Collection<DeviceUnderTest> devices) {
            this.devices = DeviceUnderTestListCopier.copy(devices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder devices(DeviceUnderTest ... devices) {
            this.devices(Arrays.asList(devices));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder devices(Consumer<DeviceUnderTest.Builder> ... devices) {
            this.devices(Stream.of(devices).map(c -> (DeviceUnderTest)((DeviceUnderTest.Builder)DeviceUnderTest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDevices(Collection<DeviceUnderTest.BuilderImpl> devices) {
            this.devices = DeviceUnderTestListCopier.copyFromBuilder(devices);
        }

        public final Boolean getIntendedForQualification() {
            return this.intendedForQualification;
        }

        @Override
        public final Builder intendedForQualification(Boolean intendedForQualification) {
            this.intendedForQualification = intendedForQualification;
            return this;
        }

        public final void setIntendedForQualification(Boolean intendedForQualification) {
            this.intendedForQualification = intendedForQualification;
        }

        public final String getRootGroup() {
            return this.rootGroup;
        }

        @Override
        public final Builder rootGroup(String rootGroup) {
            this.rootGroup = rootGroup;
            return this;
        }

        public final void setRootGroup(String rootGroup) {
            this.rootGroup = rootGroup;
        }

        public final String getDevicePermissionRoleArn() {
            return this.devicePermissionRoleArn;
        }

        @Override
        public final Builder devicePermissionRoleArn(String devicePermissionRoleArn) {
            this.devicePermissionRoleArn = devicePermissionRoleArn;
            return this;
        }

        public final void setDevicePermissionRoleArn(String devicePermissionRoleArn) {
            this.devicePermissionRoleArn = devicePermissionRoleArn;
        }

        public SuiteDefinitionConfiguration build() {
            return new SuiteDefinitionConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SuiteDefinitionConfiguration> {
        public Builder suiteDefinitionName(String var1);

        public Builder devices(Collection<DeviceUnderTest> var1);

        public Builder devices(DeviceUnderTest ... var1);

        public Builder devices(Consumer<DeviceUnderTest.Builder> ... var1);

        public Builder intendedForQualification(Boolean var1);

        public Builder rootGroup(String var1);

        public Builder devicePermissionRoleArn(String var1);
    }
}

