/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotdeviceadvisor.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSuiteRunReportResponse extends IotDeviceAdvisorResponse implements
        ToCopyableBuilder<GetSuiteRunReportResponse.Builder, GetSuiteRunReportResponse> {
    private static final SdkField<String> QUALIFICATION_REPORT_DOWNLOAD_URL_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("qualificationReportDownloadUrl")
            .getter(getter(GetSuiteRunReportResponse::qualificationReportDownloadUrl))
            .setter(setter(Builder::qualificationReportDownloadUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("qualificationReportDownloadUrl")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(QUALIFICATION_REPORT_DOWNLOAD_URL_FIELD));

    private final String qualificationReportDownloadUrl;

    private GetSuiteRunReportResponse(BuilderImpl builder) {
        super(builder);
        this.qualificationReportDownloadUrl = builder.qualificationReportDownloadUrl;
    }

    /**
     * <p>
     * Gets the download URL of the qualification report.
     * </p>
     * 
     * @return Gets the download URL of the qualification report.
     */
    public final String qualificationReportDownloadUrl() {
        return qualificationReportDownloadUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(qualificationReportDownloadUrl());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSuiteRunReportResponse)) {
            return false;
        }
        GetSuiteRunReportResponse other = (GetSuiteRunReportResponse) obj;
        return Objects.equals(qualificationReportDownloadUrl(), other.qualificationReportDownloadUrl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSuiteRunReportResponse")
                .add("QualificationReportDownloadUrl", qualificationReportDownloadUrl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "qualificationReportDownloadUrl":
            return Optional.ofNullable(clazz.cast(qualificationReportDownloadUrl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSuiteRunReportResponse, T> g) {
        return obj -> g.apply((GetSuiteRunReportResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotDeviceAdvisorResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetSuiteRunReportResponse> {
        /**
         * <p>
         * Gets the download URL of the qualification report.
         * </p>
         * 
         * @param qualificationReportDownloadUrl
         *        Gets the download URL of the qualification report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder qualificationReportDownloadUrl(String qualificationReportDownloadUrl);
    }

    static final class BuilderImpl extends IotDeviceAdvisorResponse.BuilderImpl implements Builder {
        private String qualificationReportDownloadUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSuiteRunReportResponse model) {
            super(model);
            qualificationReportDownloadUrl(model.qualificationReportDownloadUrl);
        }

        public final String getQualificationReportDownloadUrl() {
            return qualificationReportDownloadUrl;
        }

        @Override
        public final Builder qualificationReportDownloadUrl(String qualificationReportDownloadUrl) {
            this.qualificationReportDownloadUrl = qualificationReportDownloadUrl;
            return this;
        }

        public final void setQualificationReportDownloadUrl(String qualificationReportDownloadUrl) {
            this.qualificationReportDownloadUrl = qualificationReportDownloadUrl;
        }

        @Override
        public GetSuiteRunReportResponse build() {
            return new GetSuiteRunReportResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
