/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotdeviceadvisor.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSuiteDefinitionRequest extends IotDeviceAdvisorRequest implements
        ToCopyableBuilder<CreateSuiteDefinitionRequest.Builder, CreateSuiteDefinitionRequest> {
    private static final SdkField<SuiteDefinitionConfiguration> SUITE_DEFINITION_CONFIGURATION_FIELD = SdkField
            .<SuiteDefinitionConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("suiteDefinitionConfiguration")
            .getter(getter(CreateSuiteDefinitionRequest::suiteDefinitionConfiguration))
            .setter(setter(Builder::suiteDefinitionConfiguration))
            .constructor(SuiteDefinitionConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suiteDefinitionConfiguration")
                    .build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateSuiteDefinitionRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SUITE_DEFINITION_CONFIGURATION_FIELD, TAGS_FIELD));

    private final SuiteDefinitionConfiguration suiteDefinitionConfiguration;

    private final Map<String, String> tags;

    private CreateSuiteDefinitionRequest(BuilderImpl builder) {
        super(builder);
        this.suiteDefinitionConfiguration = builder.suiteDefinitionConfiguration;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * Creates a Device Advisor test suite with suite definition configuration.
     * </p>
     * 
     * @return Creates a Device Advisor test suite with suite definition configuration.
     */
    public final SuiteDefinitionConfiguration suiteDefinitionConfiguration() {
        return suiteDefinitionConfiguration;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags to be attached to the suite definition.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tags to be attached to the suite definition.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(suiteDefinitionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSuiteDefinitionRequest)) {
            return false;
        }
        CreateSuiteDefinitionRequest other = (CreateSuiteDefinitionRequest) obj;
        return Objects.equals(suiteDefinitionConfiguration(), other.suiteDefinitionConfiguration())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateSuiteDefinitionRequest")
                .add("SuiteDefinitionConfiguration", suiteDefinitionConfiguration()).add("Tags", hasTags() ? tags() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "suiteDefinitionConfiguration":
            return Optional.ofNullable(clazz.cast(suiteDefinitionConfiguration()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSuiteDefinitionRequest, T> g) {
        return obj -> g.apply((CreateSuiteDefinitionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotDeviceAdvisorRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateSuiteDefinitionRequest> {
        /**
         * <p>
         * Creates a Device Advisor test suite with suite definition configuration.
         * </p>
         * 
         * @param suiteDefinitionConfiguration
         *        Creates a Device Advisor test suite with suite definition configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suiteDefinitionConfiguration(SuiteDefinitionConfiguration suiteDefinitionConfiguration);

        /**
         * <p>
         * Creates a Device Advisor test suite with suite definition configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link SuiteDefinitionConfiguration.Builder} avoiding
         * the need to create one manually via {@link SuiteDefinitionConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link SuiteDefinitionConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #suiteDefinitionConfiguration(SuiteDefinitionConfiguration)}.
         * 
         * @param suiteDefinitionConfiguration
         *        a consumer that will call methods on {@link SuiteDefinitionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #suiteDefinitionConfiguration(SuiteDefinitionConfiguration)
         */
        default Builder suiteDefinitionConfiguration(Consumer<SuiteDefinitionConfiguration.Builder> suiteDefinitionConfiguration) {
            return suiteDefinitionConfiguration(SuiteDefinitionConfiguration.builder()
                    .applyMutation(suiteDefinitionConfiguration).build());
        }

        /**
         * <p>
         * The tags to be attached to the suite definition.
         * </p>
         * 
         * @param tags
         *        The tags to be attached to the suite definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotDeviceAdvisorRequest.BuilderImpl implements Builder {
        private SuiteDefinitionConfiguration suiteDefinitionConfiguration;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSuiteDefinitionRequest model) {
            super(model);
            suiteDefinitionConfiguration(model.suiteDefinitionConfiguration);
            tags(model.tags);
        }

        public final SuiteDefinitionConfiguration.Builder getSuiteDefinitionConfiguration() {
            return suiteDefinitionConfiguration != null ? suiteDefinitionConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder suiteDefinitionConfiguration(SuiteDefinitionConfiguration suiteDefinitionConfiguration) {
            this.suiteDefinitionConfiguration = suiteDefinitionConfiguration;
            return this;
        }

        public final void setSuiteDefinitionConfiguration(SuiteDefinitionConfiguration.BuilderImpl suiteDefinitionConfiguration) {
            this.suiteDefinitionConfiguration = suiteDefinitionConfiguration != null ? suiteDefinitionConfiguration.build()
                    : null;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSuiteDefinitionRequest build() {
            return new CreateSuiteDefinitionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
