/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotdeviceadvisor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotdeviceadvisor.model.DeviceUnderTest;
import software.amazon.awssdk.services.iotdeviceadvisor.model.SelectedTestListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SuiteRunConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SuiteRunConfiguration> {
    private static final SdkField<DeviceUnderTest> PRIMARY_DEVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("primaryDevice").getter(SuiteRunConfiguration.getter(SuiteRunConfiguration::primaryDevice)).setter(SuiteRunConfiguration.setter(Builder::primaryDevice)).constructor(DeviceUnderTest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("primaryDevice").build()}).build();
    private static final SdkField<DeviceUnderTest> SECONDARY_DEVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("secondaryDevice").getter(SuiteRunConfiguration.getter(SuiteRunConfiguration::secondaryDevice)).setter(SuiteRunConfiguration.setter(Builder::secondaryDevice)).constructor(DeviceUnderTest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secondaryDevice").build()}).build();
    private static final SdkField<List<String>> SELECTED_TEST_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("selectedTestList").getter(SuiteRunConfiguration.getter(SuiteRunConfiguration::selectedTestList)).setter(SuiteRunConfiguration.setter(Builder::selectedTestList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("selectedTestList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRIMARY_DEVICE_FIELD, SECONDARY_DEVICE_FIELD, SELECTED_TEST_LIST_FIELD));
    private static final long serialVersionUID = 1L;
    private final DeviceUnderTest primaryDevice;
    private final DeviceUnderTest secondaryDevice;
    private final List<String> selectedTestList;

    private SuiteRunConfiguration(BuilderImpl builder) {
        this.primaryDevice = builder.primaryDevice;
        this.secondaryDevice = builder.secondaryDevice;
        this.selectedTestList = builder.selectedTestList;
    }

    public DeviceUnderTest primaryDevice() {
        return this.primaryDevice;
    }

    public DeviceUnderTest secondaryDevice() {
        return this.secondaryDevice;
    }

    public boolean hasSelectedTestList() {
        return this.selectedTestList != null && !(this.selectedTestList instanceof SdkAutoConstructList);
    }

    public List<String> selectedTestList() {
        return this.selectedTestList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.primaryDevice());
        hashCode = 31 * hashCode + Objects.hashCode(this.secondaryDevice());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSelectedTestList() ? this.selectedTestList() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SuiteRunConfiguration)) {
            return false;
        }
        SuiteRunConfiguration other = (SuiteRunConfiguration)obj;
        return Objects.equals(this.primaryDevice(), other.primaryDevice()) && Objects.equals(this.secondaryDevice(), other.secondaryDevice()) && this.hasSelectedTestList() == other.hasSelectedTestList() && Objects.equals(this.selectedTestList(), other.selectedTestList());
    }

    public String toString() {
        return ToString.builder((String)"SuiteRunConfiguration").add("PrimaryDevice", (Object)this.primaryDevice()).add("SecondaryDevice", (Object)this.secondaryDevice()).add("SelectedTestList", this.hasSelectedTestList() ? this.selectedTestList() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "primaryDevice": {
                return Optional.ofNullable(clazz.cast(this.primaryDevice()));
            }
            case "secondaryDevice": {
                return Optional.ofNullable(clazz.cast(this.secondaryDevice()));
            }
            case "selectedTestList": {
                return Optional.ofNullable(clazz.cast(this.selectedTestList()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SuiteRunConfiguration, T> g) {
        return obj -> g.apply((SuiteRunConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private DeviceUnderTest primaryDevice;
        private DeviceUnderTest secondaryDevice;
        private List<String> selectedTestList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SuiteRunConfiguration model) {
            this.primaryDevice(model.primaryDevice);
            this.secondaryDevice(model.secondaryDevice);
            this.selectedTestList(model.selectedTestList);
        }

        public final DeviceUnderTest.Builder getPrimaryDevice() {
            return this.primaryDevice != null ? this.primaryDevice.toBuilder() : null;
        }

        @Override
        public final Builder primaryDevice(DeviceUnderTest primaryDevice) {
            this.primaryDevice = primaryDevice;
            return this;
        }

        public final void setPrimaryDevice(DeviceUnderTest.BuilderImpl primaryDevice) {
            this.primaryDevice = primaryDevice != null ? primaryDevice.build() : null;
        }

        public final DeviceUnderTest.Builder getSecondaryDevice() {
            return this.secondaryDevice != null ? this.secondaryDevice.toBuilder() : null;
        }

        @Override
        public final Builder secondaryDevice(DeviceUnderTest secondaryDevice) {
            this.secondaryDevice = secondaryDevice;
            return this;
        }

        public final void setSecondaryDevice(DeviceUnderTest.BuilderImpl secondaryDevice) {
            this.secondaryDevice = secondaryDevice != null ? secondaryDevice.build() : null;
        }

        public final Collection<String> getSelectedTestList() {
            if (this.selectedTestList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.selectedTestList;
        }

        @Override
        public final Builder selectedTestList(Collection<String> selectedTestList) {
            this.selectedTestList = SelectedTestListCopier.copy(selectedTestList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selectedTestList(String ... selectedTestList) {
            this.selectedTestList(Arrays.asList(selectedTestList));
            return this;
        }

        public final void setSelectedTestList(Collection<String> selectedTestList) {
            this.selectedTestList = SelectedTestListCopier.copy(selectedTestList);
        }

        public SuiteRunConfiguration build() {
            return new SuiteRunConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SuiteRunConfiguration> {
        public Builder primaryDevice(DeviceUnderTest var1);

        default public Builder primaryDevice(Consumer<DeviceUnderTest.Builder> primaryDevice) {
            return this.primaryDevice((DeviceUnderTest)((DeviceUnderTest.Builder)DeviceUnderTest.builder().applyMutation(primaryDevice)).build());
        }

        public Builder secondaryDevice(DeviceUnderTest var1);

        default public Builder secondaryDevice(Consumer<DeviceUnderTest.Builder> secondaryDevice) {
            return this.secondaryDevice((DeviceUnderTest)((DeviceUnderTest.Builder)DeviceUnderTest.builder().applyMutation(secondaryDevice)).build());
        }

        public Builder selectedTestList(Collection<String> var1);

        public Builder selectedTestList(String ... var1);
    }
}

