/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotdataplane.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteConnectionRequest extends IotDataPlaneRequest implements
        ToCopyableBuilder<DeleteConnectionRequest.Builder, DeleteConnectionRequest> {
    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clientId").getter(getter(DeleteConnectionRequest::clientId)).setter(setter(Builder::clientId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("clientId").build()).build();

    private static final SdkField<Boolean> CLEAN_SESSION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("cleanSession").getter(getter(DeleteConnectionRequest::cleanSession))
            .setter(setter(Builder::cleanSession))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("cleanSession").build()).build();

    private static final SdkField<Boolean> PREVENT_WILL_MESSAGE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("preventWillMessage").getter(getter(DeleteConnectionRequest::preventWillMessage))
            .setter(setter(Builder::preventWillMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("preventWillMessage").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_ID_FIELD,
            CLEAN_SESSION_FIELD, PREVENT_WILL_MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clientId;

    private final Boolean cleanSession;

    private final Boolean preventWillMessage;

    private DeleteConnectionRequest(BuilderImpl builder) {
        super(builder);
        this.clientId = builder.clientId;
        this.cleanSession = builder.cleanSession;
        this.preventWillMessage = builder.preventWillMessage;
    }

    /**
     * <p>
     * The unique identifier of the MQTT client to disconnect. The client ID can't start with a dollar sign ($).
     * </p>
     * 
     * @return The unique identifier of the MQTT client to disconnect. The client ID can't start with a dollar sign ($).
     */
    public final String clientId() {
        return clientId;
    }

    /**
     * <p>
     * Specifies whether to remove the client's session state when disconnecting. Set to <code>TRUE</code> to delete all
     * session information, including subscriptions and queued messages. Set to <code>FALSE</code> to preserve the
     * session state. By default, this is set to <code>FALSE</code> (preserves the session state).
     * </p>
     * 
     * @return Specifies whether to remove the client's session state when disconnecting. Set to <code>TRUE</code> to
     *         delete all session information, including subscriptions and queued messages. Set to <code>FALSE</code> to
     *         preserve the session state. By default, this is set to <code>FALSE</code> (preserves the session state).
     */
    public final Boolean cleanSession() {
        return cleanSession;
    }

    /**
     * <p>
     * Controls if Amazon Web Services IoT Core publishes the client's Last Will and Testament (LWT) message upon
     * disconnection. Set to <code>TRUE</code> to prevent publishing the LWT message. Set to <code>FALSE</code> to allow
     * publishing. By default, this is set to <code>FALSE</code> (allows publishing the LWT message).
     * </p>
     * 
     * @return Controls if Amazon Web Services IoT Core publishes the client's Last Will and Testament (LWT) message
     *         upon disconnection. Set to <code>TRUE</code> to prevent publishing the LWT message. Set to
     *         <code>FALSE</code> to allow publishing. By default, this is set to <code>FALSE</code> (allows publishing
     *         the LWT message).
     */
    public final Boolean preventWillMessage() {
        return preventWillMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientId());
        hashCode = 31 * hashCode + Objects.hashCode(cleanSession());
        hashCode = 31 * hashCode + Objects.hashCode(preventWillMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteConnectionRequest)) {
            return false;
        }
        DeleteConnectionRequest other = (DeleteConnectionRequest) obj;
        return Objects.equals(clientId(), other.clientId()) && Objects.equals(cleanSession(), other.cleanSession())
                && Objects.equals(preventWillMessage(), other.preventWillMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteConnectionRequest").add("ClientId", clientId()).add("CleanSession", cleanSession())
                .add("PreventWillMessage", preventWillMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientId":
            return Optional.ofNullable(clazz.cast(clientId()));
        case "cleanSession":
            return Optional.ofNullable(clazz.cast(cleanSession()));
        case "preventWillMessage":
            return Optional.ofNullable(clazz.cast(preventWillMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("clientId", CLIENT_ID_FIELD);
        map.put("cleanSession", CLEAN_SESSION_FIELD);
        map.put("preventWillMessage", PREVENT_WILL_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteConnectionRequest, T> g) {
        return obj -> g.apply((DeleteConnectionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IotDataPlaneRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteConnectionRequest> {
        /**
         * <p>
         * The unique identifier of the MQTT client to disconnect. The client ID can't start with a dollar sign ($).
         * </p>
         * 
         * @param clientId
         *        The unique identifier of the MQTT client to disconnect. The client ID can't start with a dollar sign
         *        ($).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientId(String clientId);

        /**
         * <p>
         * Specifies whether to remove the client's session state when disconnecting. Set to <code>TRUE</code> to delete
         * all session information, including subscriptions and queued messages. Set to <code>FALSE</code> to preserve
         * the session state. By default, this is set to <code>FALSE</code> (preserves the session state).
         * </p>
         * 
         * @param cleanSession
         *        Specifies whether to remove the client's session state when disconnecting. Set to <code>TRUE</code> to
         *        delete all session information, including subscriptions and queued messages. Set to <code>FALSE</code>
         *        to preserve the session state. By default, this is set to <code>FALSE</code> (preserves the session
         *        state).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cleanSession(Boolean cleanSession);

        /**
         * <p>
         * Controls if Amazon Web Services IoT Core publishes the client's Last Will and Testament (LWT) message upon
         * disconnection. Set to <code>TRUE</code> to prevent publishing the LWT message. Set to <code>FALSE</code> to
         * allow publishing. By default, this is set to <code>FALSE</code> (allows publishing the LWT message).
         * </p>
         * 
         * @param preventWillMessage
         *        Controls if Amazon Web Services IoT Core publishes the client's Last Will and Testament (LWT) message
         *        upon disconnection. Set to <code>TRUE</code> to prevent publishing the LWT message. Set to
         *        <code>FALSE</code> to allow publishing. By default, this is set to <code>FALSE</code> (allows
         *        publishing the LWT message).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preventWillMessage(Boolean preventWillMessage);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotDataPlaneRequest.BuilderImpl implements Builder {
        private String clientId;

        private Boolean cleanSession;

        private Boolean preventWillMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteConnectionRequest model) {
            super(model);
            clientId(model.clientId);
            cleanSession(model.cleanSession);
            preventWillMessage(model.preventWillMessage);
        }

        public final String getClientId() {
            return clientId;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final Boolean getCleanSession() {
            return cleanSession;
        }

        public final void setCleanSession(Boolean cleanSession) {
            this.cleanSession = cleanSession;
        }

        @Override
        public final Builder cleanSession(Boolean cleanSession) {
            this.cleanSession = cleanSession;
            return this;
        }

        public final Boolean getPreventWillMessage() {
            return preventWillMessage;
        }

        public final void setPreventWillMessage(Boolean preventWillMessage) {
            this.preventWillMessage = preventWillMessage;
        }

        @Override
        public final Builder preventWillMessage(Boolean preventWillMessage) {
            this.preventWillMessage = preventWillMessage;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteConnectionRequest build() {
            return new DeleteConnectionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
