/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotdataplane.endpoints.internal;

import java.net.URI;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.iotdataplane.endpoints.IotDataPlaneEndpointParams;
import software.amazon.awssdk.services.iotdataplane.endpoints.IotDataPlaneEndpointProvider;
import software.amazon.awssdk.services.iotdataplane.endpoints.internal.RulePartition;
import software.amazon.awssdk.services.iotdataplane.endpoints.internal.RuleResult;
import software.amazon.awssdk.services.iotdataplane.endpoints.internal.RulesFunctions;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class DefaultIotDataPlaneEndpointProvider
implements IotDataPlaneEndpointProvider {
    @Override
    public CompletableFuture<Endpoint> resolveEndpoint(IotDataPlaneEndpointParams params) {
        Validate.notNull((Object)params.useDualStack(), (String)"Parameter 'UseDualStack' must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)params.useFips(), (String)"Parameter 'UseFIPS' must not be null", (Object[])new Object[0]);
        try {
            Region region = params.region();
            String regionId = region == null ? null : region.id();
            RuleResult result = DefaultIotDataPlaneEndpointProvider.endpointRule0(params, regionId);
            if (result.canContinue()) {
                throw SdkClientException.create((String)"Rule engine did not reach an error or endpoint result");
            }
            if (result.isError()) {
                String errorMsg = result.error();
                if (errorMsg.contains("Invalid ARN") && errorMsg.contains(":s3:::")) {
                    errorMsg = errorMsg + ". Use the bucket name instead of simple bucket ARNs in GetBucketLocationRequest.";
                }
                throw SdkClientException.create((String)errorMsg);
            }
            return CompletableFuture.completedFuture(result.endpoint());
        }
        catch (Exception error) {
            return CompletableFutureUtils.failedFuture((Throwable)error);
        }
    }

    private static RuleResult endpointRule0(IotDataPlaneEndpointParams params, String region) {
        RuleResult result = DefaultIotDataPlaneEndpointProvider.endpointRule1(params);
        if (result.isResolved()) {
            return result;
        }
        result = DefaultIotDataPlaneEndpointProvider.endpointRule5(params, region);
        if (result.isResolved()) {
            return result;
        }
        return RuleResult.error("Invalid Configuration: Missing Region");
    }

    private static RuleResult endpointRule1(IotDataPlaneEndpointParams params) {
        if (params.endpoint() != null) {
            if (params.useFips().booleanValue()) {
                return RuleResult.error("Invalid Configuration: FIPS and custom endpoint are not supported");
            }
            if (params.useDualStack().booleanValue()) {
                return RuleResult.error("Invalid Configuration: Dualstack and custom endpoint are not supported");
            }
            return RuleResult.endpoint(Endpoint.builder().url(URI.create(params.endpoint())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule5(IotDataPlaneEndpointParams params, String region) {
        if (region != null) {
            return DefaultIotDataPlaneEndpointProvider.endpointRule6(params, region);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule6(IotDataPlaneEndpointParams params, String region) {
        RulePartition partitionResult = RulesFunctions.awsPartition(region);
        if (partitionResult != null) {
            RuleResult result = DefaultIotDataPlaneEndpointProvider.endpointRule7(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultIotDataPlaneEndpointProvider.endpointRule11(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultIotDataPlaneEndpointProvider.endpointRule22(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            if ("cn-north-1".equals(region)) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://data.ats.iot.cn-north-1.amazonaws.com.cn")).build());
            }
            if ("aws".equals(partitionResult.name())) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://data-ats.iot." + region + ".amazonaws.com")).build());
            }
            if ("aws-cn".equals(partitionResult.name())) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://data-ats.iot." + region + ".amazonaws.com.cn")).build());
            }
            if ("aws-us-gov".equals(partitionResult.name())) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://data-ats.iot." + region + ".amazonaws.com")).build());
            }
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://data-ats.iot." + region + "." + partitionResult.dnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule7(IotDataPlaneEndpointParams params, RulePartition partitionResult, String region) {
        if (params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
            RuleResult result = DefaultIotDataPlaneEndpointProvider.endpointRule8(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("FIPS and DualStack are enabled, but this partition does not support one or both");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule8(IotDataPlaneEndpointParams params, RulePartition partitionResult, String region) {
        if (partitionResult.supportsFIPS() && partitionResult.supportsDualStack()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://data-ats.iot-fips." + region + "." + partitionResult.dualStackDnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule11(IotDataPlaneEndpointParams params, RulePartition partitionResult, String region) {
        if (params.useFips().booleanValue()) {
            RuleResult result = DefaultIotDataPlaneEndpointProvider.endpointRule12(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("FIPS is enabled but this partition does not support FIPS");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule12(IotDataPlaneEndpointParams params, RulePartition partitionResult, String region) {
        if (partitionResult.supportsFIPS()) {
            if ("ca-central-1".equals(region)) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://data.iot-fips.ca-central-1.amazonaws.com")).build());
            }
            if ("us-east-1".equals(region)) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://data.iot-fips.us-east-1.amazonaws.com")).build());
            }
            if ("us-east-2".equals(region)) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://data.iot-fips.us-east-2.amazonaws.com")).build());
            }
            if ("us-west-1".equals(region)) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://data.iot-fips.us-west-1.amazonaws.com")).build());
            }
            if ("us-west-2".equals(region)) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://data.iot-fips.us-west-2.amazonaws.com")).build());
            }
            if ("us-gov-east-1".equals(region)) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://data.iot-fips.us-gov-east-1.amazonaws.com")).build());
            }
            if ("us-gov-west-1".equals(region)) {
                return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://data.iot-fips.us-gov-west-1.amazonaws.com")).build());
            }
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://data-ats.iot-fips." + region + "." + partitionResult.dnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule22(IotDataPlaneEndpointParams params, RulePartition partitionResult, String region) {
        if (params.useDualStack().booleanValue()) {
            RuleResult result = DefaultIotDataPlaneEndpointProvider.endpointRule23(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("DualStack is enabled but this partition does not support DualStack");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule23(IotDataPlaneEndpointParams params, RulePartition partitionResult, String region) {
        if (partitionResult.supportsDualStack()) {
            return RuleResult.endpoint(Endpoint.builder().url(URI.create("https://data-ats.iot." + region + "." + partitionResult.dualStackDnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    public boolean equals(Object rhs) {
        return rhs != null && this.getClass().equals(rhs.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

