/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotanalytics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DatastoreActivity
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DatastoreActivity> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(DatastoreActivity.getter(DatastoreActivity::name)).setter(DatastoreActivity.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DATASTORE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("datastoreName").getter(DatastoreActivity.getter(DatastoreActivity::datastoreName)).setter(DatastoreActivity.setter(Builder::datastoreName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datastoreName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DATASTORE_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("name", NAME_FIELD);
            this.put("datastoreName", DATASTORE_NAME_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String datastoreName;

    private DatastoreActivity(BuilderImpl builder) {
        this.name = builder.name;
        this.datastoreName = builder.datastoreName;
    }

    public final String name() {
        return this.name;
    }

    public final String datastoreName() {
        return this.datastoreName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.datastoreName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatastoreActivity)) {
            return false;
        }
        DatastoreActivity other = (DatastoreActivity)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.datastoreName(), other.datastoreName());
    }

    public final String toString() {
        return ToString.builder((String)"DatastoreActivity").add("Name", (Object)this.name()).add("DatastoreName", (Object)this.datastoreName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "datastoreName": {
                return Optional.ofNullable(clazz.cast(this.datastoreName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DatastoreActivity, T> g) {
        return obj -> g.apply((DatastoreActivity)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String datastoreName;

        private BuilderImpl() {
        }

        private BuilderImpl(DatastoreActivity model) {
            this.name(model.name);
            this.datastoreName(model.datastoreName);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDatastoreName() {
            return this.datastoreName;
        }

        public final void setDatastoreName(String datastoreName) {
            this.datastoreName = datastoreName;
        }

        @Override
        public final Builder datastoreName(String datastoreName) {
            this.datastoreName = datastoreName;
            return this;
        }

        public DatastoreActivity build() {
            return new DatastoreActivity(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DatastoreActivity> {
        public Builder name(String var1);

        public Builder datastoreName(String var1);
    }
}

