/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotanalytics.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotanalytics.IoTAnalyticsClient;
import software.amazon.awssdk.services.iotanalytics.model.ListDatasetContentsRequest;
import software.amazon.awssdk.services.iotanalytics.model.ListDatasetContentsResponse;

public class ListDatasetContentsIterable
implements SdkIterable<ListDatasetContentsResponse> {
    private final IoTAnalyticsClient client;
    private final ListDatasetContentsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDatasetContentsIterable(IoTAnalyticsClient client, ListDatasetContentsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListDatasetContentsResponseFetcher();
    }

    public Iterator<ListDatasetContentsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListDatasetContentsResponseFetcher
    implements SyncPageFetcher<ListDatasetContentsResponse> {
        private ListDatasetContentsResponseFetcher() {
        }

        public boolean hasNextPage(ListDatasetContentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDatasetContentsResponse nextPage(ListDatasetContentsResponse previousPage) {
            if (previousPage == null) {
                return ListDatasetContentsIterable.this.client.listDatasetContents(ListDatasetContentsIterable.this.firstRequest);
            }
            return ListDatasetContentsIterable.this.client.listDatasetContents((ListDatasetContentsRequest)((Object)ListDatasetContentsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

