/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotanalytics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotanalytics.model.DatasetAction;
import software.amazon.awssdk.services.iotanalytics.model.DatasetActionsCopier;
import software.amazon.awssdk.services.iotanalytics.model.DatasetContentDeliveryRule;
import software.amazon.awssdk.services.iotanalytics.model.DatasetContentDeliveryRulesCopier;
import software.amazon.awssdk.services.iotanalytics.model.DatasetTrigger;
import software.amazon.awssdk.services.iotanalytics.model.DatasetTriggersCopier;
import software.amazon.awssdk.services.iotanalytics.model.IoTAnalyticsRequest;
import software.amazon.awssdk.services.iotanalytics.model.LateDataRule;
import software.amazon.awssdk.services.iotanalytics.model.LateDataRulesCopier;
import software.amazon.awssdk.services.iotanalytics.model.RetentionPeriod;
import software.amazon.awssdk.services.iotanalytics.model.VersioningConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateDatasetRequest
extends IoTAnalyticsRequest
implements ToCopyableBuilder<Builder, UpdateDatasetRequest> {
    private static final SdkField<String> DATASET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("datasetName").getter(UpdateDatasetRequest.getter(UpdateDatasetRequest::datasetName)).setter(UpdateDatasetRequest.setter(Builder::datasetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("datasetName").build()}).build();
    private static final SdkField<List<DatasetAction>> ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("actions").getter(UpdateDatasetRequest.getter(UpdateDatasetRequest::actions)).setter(UpdateDatasetRequest.setter(Builder::actions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DatasetAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<DatasetTrigger>> TRIGGERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("triggers").getter(UpdateDatasetRequest.getter(UpdateDatasetRequest::triggers)).setter(UpdateDatasetRequest.setter(Builder::triggers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("triggers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DatasetTrigger::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<DatasetContentDeliveryRule>> CONTENT_DELIVERY_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("contentDeliveryRules").getter(UpdateDatasetRequest.getter(UpdateDatasetRequest::contentDeliveryRules)).setter(UpdateDatasetRequest.setter(Builder::contentDeliveryRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentDeliveryRules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DatasetContentDeliveryRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<RetentionPeriod> RETENTION_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("retentionPeriod").getter(UpdateDatasetRequest.getter(UpdateDatasetRequest::retentionPeriod)).setter(UpdateDatasetRequest.setter(Builder::retentionPeriod)).constructor(RetentionPeriod::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retentionPeriod").build()}).build();
    private static final SdkField<VersioningConfiguration> VERSIONING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("versioningConfiguration").getter(UpdateDatasetRequest.getter(UpdateDatasetRequest::versioningConfiguration)).setter(UpdateDatasetRequest.setter(Builder::versioningConfiguration)).constructor(VersioningConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versioningConfiguration").build()}).build();
    private static final SdkField<List<LateDataRule>> LATE_DATA_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("lateDataRules").getter(UpdateDatasetRequest.getter(UpdateDatasetRequest::lateDataRules)).setter(UpdateDatasetRequest.setter(Builder::lateDataRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lateDataRules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LateDataRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_NAME_FIELD, ACTIONS_FIELD, TRIGGERS_FIELD, CONTENT_DELIVERY_RULES_FIELD, RETENTION_PERIOD_FIELD, VERSIONING_CONFIGURATION_FIELD, LATE_DATA_RULES_FIELD));
    private final String datasetName;
    private final List<DatasetAction> actions;
    private final List<DatasetTrigger> triggers;
    private final List<DatasetContentDeliveryRule> contentDeliveryRules;
    private final RetentionPeriod retentionPeriod;
    private final VersioningConfiguration versioningConfiguration;
    private final List<LateDataRule> lateDataRules;

    private UpdateDatasetRequest(BuilderImpl builder) {
        super(builder);
        this.datasetName = builder.datasetName;
        this.actions = builder.actions;
        this.triggers = builder.triggers;
        this.contentDeliveryRules = builder.contentDeliveryRules;
        this.retentionPeriod = builder.retentionPeriod;
        this.versioningConfiguration = builder.versioningConfiguration;
        this.lateDataRules = builder.lateDataRules;
    }

    public final String datasetName() {
        return this.datasetName;
    }

    public final boolean hasActions() {
        return this.actions != null && !(this.actions instanceof SdkAutoConstructList);
    }

    public final List<DatasetAction> actions() {
        return this.actions;
    }

    public final boolean hasTriggers() {
        return this.triggers != null && !(this.triggers instanceof SdkAutoConstructList);
    }

    public final List<DatasetTrigger> triggers() {
        return this.triggers;
    }

    public final boolean hasContentDeliveryRules() {
        return this.contentDeliveryRules != null && !(this.contentDeliveryRules instanceof SdkAutoConstructList);
    }

    public final List<DatasetContentDeliveryRule> contentDeliveryRules() {
        return this.contentDeliveryRules;
    }

    public final RetentionPeriod retentionPeriod() {
        return this.retentionPeriod;
    }

    public final VersioningConfiguration versioningConfiguration() {
        return this.versioningConfiguration;
    }

    public final boolean hasLateDataRules() {
        return this.lateDataRules != null && !(this.lateDataRules instanceof SdkAutoConstructList);
    }

    public final List<LateDataRule> lateDataRules() {
        return this.lateDataRules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActions() ? this.actions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTriggers() ? this.triggers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContentDeliveryRules() ? this.contentDeliveryRules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.retentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.versioningConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLateDataRules() ? this.lateDataRules() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDatasetRequest)) {
            return false;
        }
        UpdateDatasetRequest other = (UpdateDatasetRequest)((Object)obj);
        return Objects.equals(this.datasetName(), other.datasetName()) && this.hasActions() == other.hasActions() && Objects.equals(this.actions(), other.actions()) && this.hasTriggers() == other.hasTriggers() && Objects.equals(this.triggers(), other.triggers()) && this.hasContentDeliveryRules() == other.hasContentDeliveryRules() && Objects.equals(this.contentDeliveryRules(), other.contentDeliveryRules()) && Objects.equals(this.retentionPeriod(), other.retentionPeriod()) && Objects.equals(this.versioningConfiguration(), other.versioningConfiguration()) && this.hasLateDataRules() == other.hasLateDataRules() && Objects.equals(this.lateDataRules(), other.lateDataRules());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateDatasetRequest").add("DatasetName", (Object)this.datasetName()).add("Actions", this.hasActions() ? this.actions() : null).add("Triggers", this.hasTriggers() ? this.triggers() : null).add("ContentDeliveryRules", this.hasContentDeliveryRules() ? this.contentDeliveryRules() : null).add("RetentionPeriod", (Object)this.retentionPeriod()).add("VersioningConfiguration", (Object)this.versioningConfiguration()).add("LateDataRules", this.hasLateDataRules() ? this.lateDataRules() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "datasetName": {
                return Optional.ofNullable(clazz.cast(this.datasetName()));
            }
            case "actions": {
                return Optional.ofNullable(clazz.cast(this.actions()));
            }
            case "triggers": {
                return Optional.ofNullable(clazz.cast(this.triggers()));
            }
            case "contentDeliveryRules": {
                return Optional.ofNullable(clazz.cast(this.contentDeliveryRules()));
            }
            case "retentionPeriod": {
                return Optional.ofNullable(clazz.cast(this.retentionPeriod()));
            }
            case "versioningConfiguration": {
                return Optional.ofNullable(clazz.cast(this.versioningConfiguration()));
            }
            case "lateDataRules": {
                return Optional.ofNullable(clazz.cast(this.lateDataRules()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDatasetRequest, T> g) {
        return obj -> g.apply((UpdateDatasetRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTAnalyticsRequest.BuilderImpl
    implements Builder {
        private String datasetName;
        private List<DatasetAction> actions = DefaultSdkAutoConstructList.getInstance();
        private List<DatasetTrigger> triggers = DefaultSdkAutoConstructList.getInstance();
        private List<DatasetContentDeliveryRule> contentDeliveryRules = DefaultSdkAutoConstructList.getInstance();
        private RetentionPeriod retentionPeriod;
        private VersioningConfiguration versioningConfiguration;
        private List<LateDataRule> lateDataRules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDatasetRequest model) {
            super(model);
            this.datasetName(model.datasetName);
            this.actions(model.actions);
            this.triggers(model.triggers);
            this.contentDeliveryRules(model.contentDeliveryRules);
            this.retentionPeriod(model.retentionPeriod);
            this.versioningConfiguration(model.versioningConfiguration);
            this.lateDataRules(model.lateDataRules);
        }

        public final String getDatasetName() {
            return this.datasetName;
        }

        @Override
        public final Builder datasetName(String datasetName) {
            this.datasetName = datasetName;
            return this;
        }

        public final void setDatasetName(String datasetName) {
            this.datasetName = datasetName;
        }

        public final Collection<DatasetAction.Builder> getActions() {
            if (this.actions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.actions != null ? (Collection)this.actions.stream().map(DatasetAction::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder actions(Collection<DatasetAction> actions) {
            this.actions = DatasetActionsCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(DatasetAction ... actions) {
            this.actions(Arrays.asList(actions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(Consumer<DatasetAction.Builder> ... actions) {
            this.actions(Stream.of(actions).map(c -> (DatasetAction)((DatasetAction.Builder)DatasetAction.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setActions(Collection<DatasetAction.BuilderImpl> actions) {
            this.actions = DatasetActionsCopier.copyFromBuilder(actions);
        }

        public final Collection<DatasetTrigger.Builder> getTriggers() {
            if (this.triggers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.triggers != null ? (Collection)this.triggers.stream().map(DatasetTrigger::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder triggers(Collection<DatasetTrigger> triggers) {
            this.triggers = DatasetTriggersCopier.copy(triggers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder triggers(DatasetTrigger ... triggers) {
            this.triggers(Arrays.asList(triggers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder triggers(Consumer<DatasetTrigger.Builder> ... triggers) {
            this.triggers(Stream.of(triggers).map(c -> (DatasetTrigger)((DatasetTrigger.Builder)DatasetTrigger.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTriggers(Collection<DatasetTrigger.BuilderImpl> triggers) {
            this.triggers = DatasetTriggersCopier.copyFromBuilder(triggers);
        }

        public final Collection<DatasetContentDeliveryRule.Builder> getContentDeliveryRules() {
            if (this.contentDeliveryRules instanceof SdkAutoConstructList) {
                return null;
            }
            return this.contentDeliveryRules != null ? (Collection)this.contentDeliveryRules.stream().map(DatasetContentDeliveryRule::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder contentDeliveryRules(Collection<DatasetContentDeliveryRule> contentDeliveryRules) {
            this.contentDeliveryRules = DatasetContentDeliveryRulesCopier.copy(contentDeliveryRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contentDeliveryRules(DatasetContentDeliveryRule ... contentDeliveryRules) {
            this.contentDeliveryRules(Arrays.asList(contentDeliveryRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contentDeliveryRules(Consumer<DatasetContentDeliveryRule.Builder> ... contentDeliveryRules) {
            this.contentDeliveryRules(Stream.of(contentDeliveryRules).map(c -> (DatasetContentDeliveryRule)((DatasetContentDeliveryRule.Builder)DatasetContentDeliveryRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setContentDeliveryRules(Collection<DatasetContentDeliveryRule.BuilderImpl> contentDeliveryRules) {
            this.contentDeliveryRules = DatasetContentDeliveryRulesCopier.copyFromBuilder(contentDeliveryRules);
        }

        public final RetentionPeriod.Builder getRetentionPeriod() {
            return this.retentionPeriod != null ? this.retentionPeriod.toBuilder() : null;
        }

        @Override
        public final Builder retentionPeriod(RetentionPeriod retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
            return this;
        }

        public final void setRetentionPeriod(RetentionPeriod.BuilderImpl retentionPeriod) {
            this.retentionPeriod = retentionPeriod != null ? retentionPeriod.build() : null;
        }

        public final VersioningConfiguration.Builder getVersioningConfiguration() {
            return this.versioningConfiguration != null ? this.versioningConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder versioningConfiguration(VersioningConfiguration versioningConfiguration) {
            this.versioningConfiguration = versioningConfiguration;
            return this;
        }

        public final void setVersioningConfiguration(VersioningConfiguration.BuilderImpl versioningConfiguration) {
            this.versioningConfiguration = versioningConfiguration != null ? versioningConfiguration.build() : null;
        }

        public final Collection<LateDataRule.Builder> getLateDataRules() {
            if (this.lateDataRules instanceof SdkAutoConstructList) {
                return null;
            }
            return this.lateDataRules != null ? (Collection)this.lateDataRules.stream().map(LateDataRule::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder lateDataRules(Collection<LateDataRule> lateDataRules) {
            this.lateDataRules = LateDataRulesCopier.copy(lateDataRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lateDataRules(LateDataRule ... lateDataRules) {
            this.lateDataRules(Arrays.asList(lateDataRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lateDataRules(Consumer<LateDataRule.Builder> ... lateDataRules) {
            this.lateDataRules(Stream.of(lateDataRules).map(c -> (LateDataRule)((LateDataRule.Builder)LateDataRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLateDataRules(Collection<LateDataRule.BuilderImpl> lateDataRules) {
            this.lateDataRules = LateDataRulesCopier.copyFromBuilder(lateDataRules);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDatasetRequest build() {
            return new UpdateDatasetRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IoTAnalyticsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateDatasetRequest> {
        public Builder datasetName(String var1);

        public Builder actions(Collection<DatasetAction> var1);

        public Builder actions(DatasetAction ... var1);

        public Builder actions(Consumer<DatasetAction.Builder> ... var1);

        public Builder triggers(Collection<DatasetTrigger> var1);

        public Builder triggers(DatasetTrigger ... var1);

        public Builder triggers(Consumer<DatasetTrigger.Builder> ... var1);

        public Builder contentDeliveryRules(Collection<DatasetContentDeliveryRule> var1);

        public Builder contentDeliveryRules(DatasetContentDeliveryRule ... var1);

        public Builder contentDeliveryRules(Consumer<DatasetContentDeliveryRule.Builder> ... var1);

        public Builder retentionPeriod(RetentionPeriod var1);

        default public Builder retentionPeriod(Consumer<RetentionPeriod.Builder> retentionPeriod) {
            return this.retentionPeriod((RetentionPeriod)((RetentionPeriod.Builder)RetentionPeriod.builder().applyMutation(retentionPeriod)).build());
        }

        public Builder versioningConfiguration(VersioningConfiguration var1);

        default public Builder versioningConfiguration(Consumer<VersioningConfiguration.Builder> versioningConfiguration) {
            return this.versioningConfiguration((VersioningConfiguration)((VersioningConfiguration.Builder)VersioningConfiguration.builder().applyMutation(versioningConfiguration)).build());
        }

        public Builder lateDataRules(Collection<LateDataRule> var1);

        public Builder lateDataRules(LateDataRule ... var1);

        public Builder lateDataRules(Consumer<LateDataRule.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

