/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotanalytics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdatePipelineRequest extends IoTAnalyticsRequest implements
        ToCopyableBuilder<UpdatePipelineRequest.Builder, UpdatePipelineRequest> {
    private static final SdkField<String> PIPELINE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("pipelineName").getter(getter(UpdatePipelineRequest::pipelineName)).setter(setter(Builder::pipelineName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("pipelineName").build()).build();

    private static final SdkField<List<PipelineActivity>> PIPELINE_ACTIVITIES_FIELD = SdkField
            .<List<PipelineActivity>> builder(MarshallingType.LIST)
            .memberName("pipelineActivities")
            .getter(getter(UpdatePipelineRequest::pipelineActivities))
            .setter(setter(Builder::pipelineActivities))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineActivities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PipelineActivity> builder(MarshallingType.SDK_POJO)
                                            .constructor(PipelineActivity::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_NAME_FIELD,
            PIPELINE_ACTIVITIES_FIELD));

    private final String pipelineName;

    private final List<PipelineActivity> pipelineActivities;

    private UpdatePipelineRequest(BuilderImpl builder) {
        super(builder);
        this.pipelineName = builder.pipelineName;
        this.pipelineActivities = builder.pipelineActivities;
    }

    /**
     * <p>
     * The name of the pipeline to update.
     * </p>
     * 
     * @return The name of the pipeline to update.
     */
    public final String pipelineName() {
        return pipelineName;
    }

    /**
     * Returns true if the PipelineActivities property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasPipelineActivities() {
        return pipelineActivities != null && !(pipelineActivities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>PipelineActivity</code> objects. Activities perform transformations on your messages, such as
     * removing, renaming or adding message attributes; filtering messages based on attribute values; invoking your
     * Lambda functions on messages for advanced processing; or performing mathematical transformations to normalize
     * device data.
     * </p>
     * <p>
     * The list can be 2-25 <code>PipelineActivity</code> objects and must contain both a <code>channel</code> and a
     * <code>datastore</code> activity. Each entry in the list must contain only one activity. For example:
     * </p>
     * <p>
     * <code>pipelineActivities = [ { "channel": { ... } }, { "lambda": { ... } }, ... ]</code>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPipelineActivities()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of <code>PipelineActivity</code> objects. Activities perform transformations on your messages,
     *         such as removing, renaming or adding message attributes; filtering messages based on attribute values;
     *         invoking your Lambda functions on messages for advanced processing; or performing mathematical
     *         transformations to normalize device data.</p>
     *         <p>
     *         The list can be 2-25 <code>PipelineActivity</code> objects and must contain both a <code>channel</code>
     *         and a <code>datastore</code> activity. Each entry in the list must contain only one activity. For
     *         example:
     *         </p>
     *         <p>
     *         <code>pipelineActivities = [ { "channel": { ... } }, { "lambda": { ... } }, ... ]</code>
     */
    public final List<PipelineActivity> pipelineActivities() {
        return pipelineActivities;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(pipelineName());
        hashCode = 31 * hashCode + Objects.hashCode(hasPipelineActivities() ? pipelineActivities() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePipelineRequest)) {
            return false;
        }
        UpdatePipelineRequest other = (UpdatePipelineRequest) obj;
        return Objects.equals(pipelineName(), other.pipelineName()) && hasPipelineActivities() == other.hasPipelineActivities()
                && Objects.equals(pipelineActivities(), other.pipelineActivities());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdatePipelineRequest").add("PipelineName", pipelineName())
                .add("PipelineActivities", hasPipelineActivities() ? pipelineActivities() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "pipelineName":
            return Optional.ofNullable(clazz.cast(pipelineName()));
        case "pipelineActivities":
            return Optional.ofNullable(clazz.cast(pipelineActivities()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdatePipelineRequest, T> g) {
        return obj -> g.apply((UpdatePipelineRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTAnalyticsRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdatePipelineRequest> {
        /**
         * <p>
         * The name of the pipeline to update.
         * </p>
         * 
         * @param pipelineName
         *        The name of the pipeline to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineName(String pipelineName);

        /**
         * <p>
         * A list of <code>PipelineActivity</code> objects. Activities perform transformations on your messages, such as
         * removing, renaming or adding message attributes; filtering messages based on attribute values; invoking your
         * Lambda functions on messages for advanced processing; or performing mathematical transformations to normalize
         * device data.
         * </p>
         * <p>
         * The list can be 2-25 <code>PipelineActivity</code> objects and must contain both a <code>channel</code> and a
         * <code>datastore</code> activity. Each entry in the list must contain only one activity. For example:
         * </p>
         * <p>
         * <code>pipelineActivities = [ { "channel": { ... } }, { "lambda": { ... } }, ... ]</code>
         * </p>
         * 
         * @param pipelineActivities
         *        A list of <code>PipelineActivity</code> objects. Activities perform transformations on your messages,
         *        such as removing, renaming or adding message attributes; filtering messages based on attribute values;
         *        invoking your Lambda functions on messages for advanced processing; or performing mathematical
         *        transformations to normalize device data.</p>
         *        <p>
         *        The list can be 2-25 <code>PipelineActivity</code> objects and must contain both a
         *        <code>channel</code> and a <code>datastore</code> activity. Each entry in the list must contain only
         *        one activity. For example:
         *        </p>
         *        <p>
         *        <code>pipelineActivities = [ { "channel": { ... } }, { "lambda": { ... } }, ... ]</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineActivities(Collection<PipelineActivity> pipelineActivities);

        /**
         * <p>
         * A list of <code>PipelineActivity</code> objects. Activities perform transformations on your messages, such as
         * removing, renaming or adding message attributes; filtering messages based on attribute values; invoking your
         * Lambda functions on messages for advanced processing; or performing mathematical transformations to normalize
         * device data.
         * </p>
         * <p>
         * The list can be 2-25 <code>PipelineActivity</code> objects and must contain both a <code>channel</code> and a
         * <code>datastore</code> activity. Each entry in the list must contain only one activity. For example:
         * </p>
         * <p>
         * <code>pipelineActivities = [ { "channel": { ... } }, { "lambda": { ... } }, ... ]</code>
         * </p>
         * 
         * @param pipelineActivities
         *        A list of <code>PipelineActivity</code> objects. Activities perform transformations on your messages,
         *        such as removing, renaming or adding message attributes; filtering messages based on attribute values;
         *        invoking your Lambda functions on messages for advanced processing; or performing mathematical
         *        transformations to normalize device data.</p>
         *        <p>
         *        The list can be 2-25 <code>PipelineActivity</code> objects and must contain both a
         *        <code>channel</code> and a <code>datastore</code> activity. Each entry in the list must contain only
         *        one activity. For example:
         *        </p>
         *        <p>
         *        <code>pipelineActivities = [ { "channel": { ... } }, { "lambda": { ... } }, ... ]</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineActivities(PipelineActivity... pipelineActivities);

        /**
         * <p>
         * A list of <code>PipelineActivity</code> objects. Activities perform transformations on your messages, such as
         * removing, renaming or adding message attributes; filtering messages based on attribute values; invoking your
         * Lambda functions on messages for advanced processing; or performing mathematical transformations to normalize
         * device data.
         * </p>
         * <p>
         * The list can be 2-25 <code>PipelineActivity</code> objects and must contain both a <code>channel</code> and a
         * <code>datastore</code> activity. Each entry in the list must contain only one activity. For example:
         * </p>
         * <p>
         * <code>pipelineActivities = [ { "channel": { ... } }, { "lambda": { ... } }, ... ]</code>
         * </p>
         * This is a convenience that creates an instance of the {@link List<PipelineActivity>.Builder} avoiding the
         * need to create one manually via {@link List<PipelineActivity>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PipelineActivity>.Builder#build()} is called immediately and
         * its result is passed to {@link #pipelineActivities(List<PipelineActivity>)}.
         * 
         * @param pipelineActivities
         *        a consumer that will call methods on {@link List<PipelineActivity>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pipelineActivities(List<PipelineActivity>)
         */
        Builder pipelineActivities(Consumer<PipelineActivity.Builder>... pipelineActivities);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTAnalyticsRequest.BuilderImpl implements Builder {
        private String pipelineName;

        private List<PipelineActivity> pipelineActivities = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePipelineRequest model) {
            super(model);
            pipelineName(model.pipelineName);
            pipelineActivities(model.pipelineActivities);
        }

        public final String getPipelineName() {
            return pipelineName;
        }

        @Override
        public final Builder pipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
            return this;
        }

        public final void setPipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
        }

        public final Collection<PipelineActivity.Builder> getPipelineActivities() {
            if (pipelineActivities instanceof SdkAutoConstructList) {
                return null;
            }
            return pipelineActivities != null ? pipelineActivities.stream().map(PipelineActivity::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder pipelineActivities(Collection<PipelineActivity> pipelineActivities) {
            this.pipelineActivities = PipelineActivitiesCopier.copy(pipelineActivities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pipelineActivities(PipelineActivity... pipelineActivities) {
            pipelineActivities(Arrays.asList(pipelineActivities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pipelineActivities(Consumer<PipelineActivity.Builder>... pipelineActivities) {
            pipelineActivities(Stream.of(pipelineActivities).map(c -> PipelineActivity.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setPipelineActivities(Collection<PipelineActivity.BuilderImpl> pipelineActivities) {
            this.pipelineActivities = PipelineActivitiesCopier.copyFromBuilder(pipelineActivities);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdatePipelineRequest build() {
            return new UpdatePipelineRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
