/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotanalytics.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RunPipelineActivityResponse extends IoTAnalyticsResponse implements
        ToCopyableBuilder<RunPipelineActivityResponse.Builder, RunPipelineActivityResponse> {
    private static final SdkField<List<SdkBytes>> PAYLOADS_FIELD = SdkField
            .<List<SdkBytes>> builder(MarshallingType.LIST)
            .memberName("payloads")
            .getter(getter(RunPipelineActivityResponse::payloads))
            .setter(setter(Builder::payloads))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("payloads").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> LOG_RESULT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("logResult").getter(getter(RunPipelineActivityResponse::logResult)).setter(setter(Builder::logResult))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logResult").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PAYLOADS_FIELD,
            LOG_RESULT_FIELD));

    private final List<SdkBytes> payloads;

    private final String logResult;

    private RunPipelineActivityResponse(BuilderImpl builder) {
        super(builder);
        this.payloads = builder.payloads;
        this.logResult = builder.logResult;
    }

    /**
     * Returns true if the Payloads property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasPayloads() {
        return payloads != null && !(payloads instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The enriched or transformed sample message payloads as base64-encoded strings. (The results of running the
     * pipeline activity on each input sample message payload, encoded in base64.)
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPayloads()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The enriched or transformed sample message payloads as base64-encoded strings. (The results of running
     *         the pipeline activity on each input sample message payload, encoded in base64.)
     */
    public final List<SdkBytes> payloads() {
        return payloads;
    }

    /**
     * <p>
     * In case the pipeline activity fails, the log message that is generated.
     * </p>
     * 
     * @return In case the pipeline activity fails, the log message that is generated.
     */
    public final String logResult() {
        return logResult;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasPayloads() ? payloads() : null);
        hashCode = 31 * hashCode + Objects.hashCode(logResult());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RunPipelineActivityResponse)) {
            return false;
        }
        RunPipelineActivityResponse other = (RunPipelineActivityResponse) obj;
        return hasPayloads() == other.hasPayloads() && Objects.equals(payloads(), other.payloads())
                && Objects.equals(logResult(), other.logResult());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RunPipelineActivityResponse").add("Payloads", hasPayloads() ? payloads() : null)
                .add("LogResult", logResult()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "payloads":
            return Optional.ofNullable(clazz.cast(payloads()));
        case "logResult":
            return Optional.ofNullable(clazz.cast(logResult()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RunPipelineActivityResponse, T> g) {
        return obj -> g.apply((RunPipelineActivityResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTAnalyticsResponse.Builder, SdkPojo, CopyableBuilder<Builder, RunPipelineActivityResponse> {
        /**
         * <p>
         * The enriched or transformed sample message payloads as base64-encoded strings. (The results of running the
         * pipeline activity on each input sample message payload, encoded in base64.)
         * </p>
         * 
         * @param payloads
         *        The enriched or transformed sample message payloads as base64-encoded strings. (The results of running
         *        the pipeline activity on each input sample message payload, encoded in base64.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder payloads(Collection<SdkBytes> payloads);

        /**
         * <p>
         * The enriched or transformed sample message payloads as base64-encoded strings. (The results of running the
         * pipeline activity on each input sample message payload, encoded in base64.)
         * </p>
         * 
         * @param payloads
         *        The enriched or transformed sample message payloads as base64-encoded strings. (The results of running
         *        the pipeline activity on each input sample message payload, encoded in base64.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder payloads(SdkBytes... payloads);

        /**
         * <p>
         * In case the pipeline activity fails, the log message that is generated.
         * </p>
         * 
         * @param logResult
         *        In case the pipeline activity fails, the log message that is generated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logResult(String logResult);
    }

    static final class BuilderImpl extends IoTAnalyticsResponse.BuilderImpl implements Builder {
        private List<SdkBytes> payloads = DefaultSdkAutoConstructList.getInstance();

        private String logResult;

        private BuilderImpl() {
        }

        private BuilderImpl(RunPipelineActivityResponse model) {
            super(model);
            payloads(model.payloads);
            logResult(model.logResult);
        }

        public final List<ByteBuffer> getPayloads() {
            if (payloads instanceof SdkAutoConstructList) {
                return null;
            }
            return payloads == null ? null : payloads.stream().map(SdkBytes::asByteBuffer).collect(Collectors.toList());
        }

        @Override
        public final Builder payloads(Collection<SdkBytes> payloads) {
            this.payloads = MessagePayloadsCopier.copy(payloads);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder payloads(SdkBytes... payloads) {
            payloads(Arrays.asList(payloads));
            return this;
        }

        public final void setPayloads(Collection<ByteBuffer> payloads) {
            payloads(payloads == null ? null : payloads.stream().map(SdkBytes::fromByteBuffer).collect(Collectors.toList()));
        }

        public final String getLogResult() {
            return logResult;
        }

        @Override
        public final Builder logResult(String logResult) {
            this.logResult = logResult;
            return this;
        }

        public final void setLogResult(String logResult) {
            this.logResult = logResult;
        }

        @Override
        public RunPipelineActivityResponse build() {
            return new RunPipelineActivityResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
