/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotanalytics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotanalytics.model.DatasetContentSummariesCopier;
import software.amazon.awssdk.services.iotanalytics.model.DatasetContentSummary;
import software.amazon.awssdk.services.iotanalytics.model.IoTAnalyticsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDatasetContentsResponse
extends IoTAnalyticsResponse
implements ToCopyableBuilder<Builder, ListDatasetContentsResponse> {
    private static final SdkField<List<DatasetContentSummary>> DATASET_CONTENT_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListDatasetContentsResponse.getter(ListDatasetContentsResponse::datasetContentSummaries)).setter(ListDatasetContentsResponse.setter(Builder::datasetContentSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetContentSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DatasetContentSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListDatasetContentsResponse.getter(ListDatasetContentsResponse::nextToken)).setter(ListDatasetContentsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_CONTENT_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<DatasetContentSummary> datasetContentSummaries;
    private final String nextToken;

    private ListDatasetContentsResponse(BuilderImpl builder) {
        super(builder);
        this.datasetContentSummaries = builder.datasetContentSummaries;
        this.nextToken = builder.nextToken;
    }

    public boolean hasDatasetContentSummaries() {
        return this.datasetContentSummaries != null && !(this.datasetContentSummaries instanceof SdkAutoConstructList);
    }

    public List<DatasetContentSummary> datasetContentSummaries() {
        return this.datasetContentSummaries;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.datasetContentSummaries());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDatasetContentsResponse)) {
            return false;
        }
        ListDatasetContentsResponse other = (ListDatasetContentsResponse)((Object)obj);
        return Objects.equals(this.datasetContentSummaries(), other.datasetContentSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListDatasetContentsResponse").add("DatasetContentSummaries", this.datasetContentSummaries()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "datasetContentSummaries": {
                return Optional.ofNullable(clazz.cast(this.datasetContentSummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDatasetContentsResponse, T> g) {
        return obj -> g.apply((ListDatasetContentsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTAnalyticsResponse.BuilderImpl
    implements Builder {
        private List<DatasetContentSummary> datasetContentSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDatasetContentsResponse model) {
            super(model);
            this.datasetContentSummaries(model.datasetContentSummaries);
            this.nextToken(model.nextToken);
        }

        public final Collection<DatasetContentSummary.Builder> getDatasetContentSummaries() {
            return this.datasetContentSummaries != null ? (Collection)this.datasetContentSummaries.stream().map(DatasetContentSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder datasetContentSummaries(Collection<DatasetContentSummary> datasetContentSummaries) {
            this.datasetContentSummaries = DatasetContentSummariesCopier.copy(datasetContentSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder datasetContentSummaries(DatasetContentSummary ... datasetContentSummaries) {
            this.datasetContentSummaries(Arrays.asList(datasetContentSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder datasetContentSummaries(Consumer<DatasetContentSummary.Builder> ... datasetContentSummaries) {
            this.datasetContentSummaries(Stream.of(datasetContentSummaries).map(c -> (DatasetContentSummary)((DatasetContentSummary.Builder)DatasetContentSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDatasetContentSummaries(Collection<DatasetContentSummary.BuilderImpl> datasetContentSummaries) {
            this.datasetContentSummaries = DatasetContentSummariesCopier.copyFromBuilder(datasetContentSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListDatasetContentsResponse build() {
            return new ListDatasetContentsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IoTAnalyticsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDatasetContentsResponse> {
        public Builder datasetContentSummaries(Collection<DatasetContentSummary> var1);

        public Builder datasetContentSummaries(DatasetContentSummary ... var1);

        public Builder datasetContentSummaries(Consumer<DatasetContentSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

