/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotanalytics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration of the resource used to execute the "containerAction".
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ResourceConfiguration.Builder, ResourceConfiguration> {
    private static final SdkField<String> COMPUTE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ResourceConfiguration::computeTypeAsString)).setter(setter(Builder::computeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computeType").build()).build();

    private static final SdkField<Integer> VOLUME_SIZE_IN_GB_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ResourceConfiguration::volumeSizeInGB)).setter(setter(Builder::volumeSizeInGB))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumeSizeInGB").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPUTE_TYPE_FIELD,
            VOLUME_SIZE_IN_GB_FIELD));

    private static final long serialVersionUID = 1L;

    private final String computeType;

    private final Integer volumeSizeInGB;

    private ResourceConfiguration(BuilderImpl builder) {
        this.computeType = builder.computeType;
        this.volumeSizeInGB = builder.volumeSizeInGB;
    }

    /**
     * <p>
     * The type of the compute resource used to execute the "containerAction". Possible values are: ACU_1 (vCPU=4,
     * memory=16GiB) or ACU_2 (vCPU=8, memory=32GiB).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #computeType} will
     * return {@link ComputeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #computeTypeAsString}.
     * </p>
     * 
     * @return The type of the compute resource used to execute the "containerAction". Possible values are: ACU_1
     *         (vCPU=4, memory=16GiB) or ACU_2 (vCPU=8, memory=32GiB).
     * @see ComputeType
     */
    public ComputeType computeType() {
        return ComputeType.fromValue(computeType);
    }

    /**
     * <p>
     * The type of the compute resource used to execute the "containerAction". Possible values are: ACU_1 (vCPU=4,
     * memory=16GiB) or ACU_2 (vCPU=8, memory=32GiB).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #computeType} will
     * return {@link ComputeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #computeTypeAsString}.
     * </p>
     * 
     * @return The type of the compute resource used to execute the "containerAction". Possible values are: ACU_1
     *         (vCPU=4, memory=16GiB) or ACU_2 (vCPU=8, memory=32GiB).
     * @see ComputeType
     */
    public String computeTypeAsString() {
        return computeType;
    }

    /**
     * <p>
     * The size (in GB) of the persistent storage available to the resource instance used to execute the
     * "containerAction" (min: 1, max: 50).
     * </p>
     * 
     * @return The size (in GB) of the persistent storage available to the resource instance used to execute the
     *         "containerAction" (min: 1, max: 50).
     */
    public Integer volumeSizeInGB() {
        return volumeSizeInGB;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(computeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(volumeSizeInGB());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceConfiguration)) {
            return false;
        }
        ResourceConfiguration other = (ResourceConfiguration) obj;
        return Objects.equals(computeTypeAsString(), other.computeTypeAsString())
                && Objects.equals(volumeSizeInGB(), other.volumeSizeInGB());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ResourceConfiguration").add("ComputeType", computeTypeAsString())
                .add("VolumeSizeInGB", volumeSizeInGB()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "computeType":
            return Optional.ofNullable(clazz.cast(computeTypeAsString()));
        case "volumeSizeInGB":
            return Optional.ofNullable(clazz.cast(volumeSizeInGB()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceConfiguration, T> g) {
        return obj -> g.apply((ResourceConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceConfiguration> {
        /**
         * <p>
         * The type of the compute resource used to execute the "containerAction". Possible values are: ACU_1 (vCPU=4,
         * memory=16GiB) or ACU_2 (vCPU=8, memory=32GiB).
         * </p>
         * 
         * @param computeType
         *        The type of the compute resource used to execute the "containerAction". Possible values are: ACU_1
         *        (vCPU=4, memory=16GiB) or ACU_2 (vCPU=8, memory=32GiB).
         * @see ComputeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComputeType
         */
        Builder computeType(String computeType);

        /**
         * <p>
         * The type of the compute resource used to execute the "containerAction". Possible values are: ACU_1 (vCPU=4,
         * memory=16GiB) or ACU_2 (vCPU=8, memory=32GiB).
         * </p>
         * 
         * @param computeType
         *        The type of the compute resource used to execute the "containerAction". Possible values are: ACU_1
         *        (vCPU=4, memory=16GiB) or ACU_2 (vCPU=8, memory=32GiB).
         * @see ComputeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComputeType
         */
        Builder computeType(ComputeType computeType);

        /**
         * <p>
         * The size (in GB) of the persistent storage available to the resource instance used to execute the
         * "containerAction" (min: 1, max: 50).
         * </p>
         * 
         * @param volumeSizeInGB
         *        The size (in GB) of the persistent storage available to the resource instance used to execute the
         *        "containerAction" (min: 1, max: 50).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeSizeInGB(Integer volumeSizeInGB);
    }

    static final class BuilderImpl implements Builder {
        private String computeType;

        private Integer volumeSizeInGB;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceConfiguration model) {
            computeType(model.computeType);
            volumeSizeInGB(model.volumeSizeInGB);
        }

        public final String getComputeType() {
            return computeType;
        }

        @Override
        public final Builder computeType(String computeType) {
            this.computeType = computeType;
            return this;
        }

        @Override
        public final Builder computeType(ComputeType computeType) {
            this.computeType(computeType == null ? null : computeType.toString());
            return this;
        }

        public final void setComputeType(String computeType) {
            this.computeType = computeType;
        }

        public final Integer getVolumeSizeInGB() {
            return volumeSizeInGB;
        }

        @Override
        public final Builder volumeSizeInGB(Integer volumeSizeInGB) {
            this.volumeSizeInGB = volumeSizeInGB;
            return this;
        }

        public final void setVolumeSizeInGB(Integer volumeSizeInGB) {
            this.volumeSizeInGB = volumeSizeInGB;
        }

        @Override
        public ResourceConfiguration build() {
            return new ResourceConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
