/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotanalytics.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeChannelResponse extends IoTAnalyticsResponse implements
        ToCopyableBuilder<DescribeChannelResponse.Builder, DescribeChannelResponse> {
    private static final SdkField<Channel> CHANNEL_FIELD = SdkField.<Channel> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribeChannelResponse::channel)).setter(setter(Builder::channel)).constructor(Channel::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channel").build()).build();

    private static final SdkField<ChannelStatistics> STATISTICS_FIELD = SdkField
            .<ChannelStatistics> builder(MarshallingType.SDK_POJO).getter(getter(DescribeChannelResponse::statistics))
            .setter(setter(Builder::statistics)).constructor(ChannelStatistics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statistics").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_FIELD,
            STATISTICS_FIELD));

    private final Channel channel;

    private final ChannelStatistics statistics;

    private DescribeChannelResponse(BuilderImpl builder) {
        super(builder);
        this.channel = builder.channel;
        this.statistics = builder.statistics;
    }

    /**
     * <p>
     * An object that contains information about the channel.
     * </p>
     * 
     * @return An object that contains information about the channel.
     */
    public Channel channel() {
        return channel;
    }

    /**
     * <p>
     * Statistics about the channel. Included if the 'includeStatistics' parameter is set to true in the request.
     * </p>
     * 
     * @return Statistics about the channel. Included if the 'includeStatistics' parameter is set to true in the
     *         request.
     */
    public ChannelStatistics statistics() {
        return statistics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(channel());
        hashCode = 31 * hashCode + Objects.hashCode(statistics());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeChannelResponse)) {
            return false;
        }
        DescribeChannelResponse other = (DescribeChannelResponse) obj;
        return Objects.equals(channel(), other.channel()) && Objects.equals(statistics(), other.statistics());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeChannelResponse").add("Channel", channel()).add("Statistics", statistics()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "channel":
            return Optional.ofNullable(clazz.cast(channel()));
        case "statistics":
            return Optional.ofNullable(clazz.cast(statistics()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeChannelResponse, T> g) {
        return obj -> g.apply((DescribeChannelResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTAnalyticsResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeChannelResponse> {
        /**
         * <p>
         * An object that contains information about the channel.
         * </p>
         * 
         * @param channel
         *        An object that contains information about the channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channel(Channel channel);

        /**
         * <p>
         * An object that contains information about the channel.
         * </p>
         * This is a convenience that creates an instance of the {@link Channel.Builder} avoiding the need to create one
         * manually via {@link Channel#builder()}.
         *
         * When the {@link Consumer} completes, {@link Channel.Builder#build()} is called immediately and its result is
         * passed to {@link #channel(Channel)}.
         * 
         * @param channel
         *        a consumer that will call methods on {@link Channel.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #channel(Channel)
         */
        default Builder channel(Consumer<Channel.Builder> channel) {
            return channel(Channel.builder().applyMutation(channel).build());
        }

        /**
         * <p>
         * Statistics about the channel. Included if the 'includeStatistics' parameter is set to true in the request.
         * </p>
         * 
         * @param statistics
         *        Statistics about the channel. Included if the 'includeStatistics' parameter is set to true in the
         *        request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statistics(ChannelStatistics statistics);

        /**
         * <p>
         * Statistics about the channel. Included if the 'includeStatistics' parameter is set to true in the request.
         * </p>
         * This is a convenience that creates an instance of the {@link ChannelStatistics.Builder} avoiding the need to
         * create one manually via {@link ChannelStatistics#builder()}.
         *
         * When the {@link Consumer} completes, {@link ChannelStatistics.Builder#build()} is called immediately and its
         * result is passed to {@link #statistics(ChannelStatistics)}.
         * 
         * @param statistics
         *        a consumer that will call methods on {@link ChannelStatistics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #statistics(ChannelStatistics)
         */
        default Builder statistics(Consumer<ChannelStatistics.Builder> statistics) {
            return statistics(ChannelStatistics.builder().applyMutation(statistics).build());
        }
    }

    static final class BuilderImpl extends IoTAnalyticsResponse.BuilderImpl implements Builder {
        private Channel channel;

        private ChannelStatistics statistics;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeChannelResponse model) {
            super(model);
            channel(model.channel);
            statistics(model.statistics);
        }

        public final Channel.Builder getChannel() {
            return channel != null ? channel.toBuilder() : null;
        }

        @Override
        public final Builder channel(Channel channel) {
            this.channel = channel;
            return this;
        }

        public final void setChannel(Channel.BuilderImpl channel) {
            this.channel = channel != null ? channel.build() : null;
        }

        public final ChannelStatistics.Builder getStatistics() {
            return statistics != null ? statistics.toBuilder() : null;
        }

        @Override
        public final Builder statistics(ChannelStatistics statistics) {
            this.statistics = statistics;
            return this;
        }

        public final void setStatistics(ChannelStatistics.BuilderImpl statistics) {
            this.statistics = statistics != null ? statistics.build() : null;
        }

        @Override
        public DescribeChannelResponse build() {
            return new DescribeChannelResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
