/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.SearchableAttributesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ThingTypeProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ThingTypeProperties> {
    private static final SdkField<String> THING_TYPE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ThingTypeProperties.getter(ThingTypeProperties::thingTypeDescription)).setter(ThingTypeProperties.setter(Builder::thingTypeDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingTypeDescription").build()}).build();
    private static final SdkField<List<String>> SEARCHABLE_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ThingTypeProperties.getter(ThingTypeProperties::searchableAttributes)).setter(ThingTypeProperties.setter(Builder::searchableAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("searchableAttributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THING_TYPE_DESCRIPTION_FIELD, SEARCHABLE_ATTRIBUTES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String thingTypeDescription;
    private final List<String> searchableAttributes;

    private ThingTypeProperties(BuilderImpl builder) {
        this.thingTypeDescription = builder.thingTypeDescription;
        this.searchableAttributes = builder.searchableAttributes;
    }

    public String thingTypeDescription() {
        return this.thingTypeDescription;
    }

    public List<String> searchableAttributes() {
        return this.searchableAttributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.thingTypeDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.searchableAttributes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThingTypeProperties)) {
            return false;
        }
        ThingTypeProperties other = (ThingTypeProperties)obj;
        return Objects.equals(this.thingTypeDescription(), other.thingTypeDescription()) && Objects.equals(this.searchableAttributes(), other.searchableAttributes());
    }

    public String toString() {
        return ToString.builder((String)"ThingTypeProperties").add("ThingTypeDescription", (Object)this.thingTypeDescription()).add("SearchableAttributes", this.searchableAttributes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "thingTypeDescription": {
                return Optional.ofNullable(clazz.cast(this.thingTypeDescription()));
            }
            case "searchableAttributes": {
                return Optional.ofNullable(clazz.cast(this.searchableAttributes()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ThingTypeProperties, T> g) {
        return obj -> g.apply((ThingTypeProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String thingTypeDescription;
        private List<String> searchableAttributes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ThingTypeProperties model) {
            this.thingTypeDescription(model.thingTypeDescription);
            this.searchableAttributes(model.searchableAttributes);
        }

        public final String getThingTypeDescription() {
            return this.thingTypeDescription;
        }

        @Override
        public final Builder thingTypeDescription(String thingTypeDescription) {
            this.thingTypeDescription = thingTypeDescription;
            return this;
        }

        public final void setThingTypeDescription(String thingTypeDescription) {
            this.thingTypeDescription = thingTypeDescription;
        }

        public final Collection<String> getSearchableAttributes() {
            return this.searchableAttributes;
        }

        @Override
        public final Builder searchableAttributes(Collection<String> searchableAttributes) {
            this.searchableAttributes = SearchableAttributesCopier.copy(searchableAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder searchableAttributes(String ... searchableAttributes) {
            this.searchableAttributes(Arrays.asList(searchableAttributes));
            return this;
        }

        public final void setSearchableAttributes(Collection<String> searchableAttributes) {
            this.searchableAttributes = SearchableAttributesCopier.copy(searchableAttributes);
        }

        public ThingTypeProperties build() {
            return new ThingTypeProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ThingTypeProperties> {
        public Builder thingTypeDescription(String var1);

        public Builder searchableAttributes(Collection<String> var1);

        public Builder searchableAttributes(String ... var1);
    }
}

