/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.JobExecutionSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JobExecutionSummaryForJob
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JobExecutionSummaryForJob> {
    private static final SdkField<String> THING_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(JobExecutionSummaryForJob.getter(JobExecutionSummaryForJob::thingArn)).setter(JobExecutionSummaryForJob.setter(Builder::thingArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingArn").build()}).build();
    private static final SdkField<JobExecutionSummary> JOB_EXECUTION_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(JobExecutionSummaryForJob.getter(JobExecutionSummaryForJob::jobExecutionSummary)).setter(JobExecutionSummaryForJob.setter(Builder::jobExecutionSummary)).constructor(JobExecutionSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobExecutionSummary").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THING_ARN_FIELD, JOB_EXECUTION_SUMMARY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String thingArn;
    private final JobExecutionSummary jobExecutionSummary;

    private JobExecutionSummaryForJob(BuilderImpl builder) {
        this.thingArn = builder.thingArn;
        this.jobExecutionSummary = builder.jobExecutionSummary;
    }

    public String thingArn() {
        return this.thingArn;
    }

    public JobExecutionSummary jobExecutionSummary() {
        return this.jobExecutionSummary;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.thingArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobExecutionSummary());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobExecutionSummaryForJob)) {
            return false;
        }
        JobExecutionSummaryForJob other = (JobExecutionSummaryForJob)obj;
        return Objects.equals(this.thingArn(), other.thingArn()) && Objects.equals(this.jobExecutionSummary(), other.jobExecutionSummary());
    }

    public String toString() {
        return ToString.builder((String)"JobExecutionSummaryForJob").add("ThingArn", (Object)this.thingArn()).add("JobExecutionSummary", (Object)this.jobExecutionSummary()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "thingArn": {
                return Optional.ofNullable(clazz.cast(this.thingArn()));
            }
            case "jobExecutionSummary": {
                return Optional.ofNullable(clazz.cast(this.jobExecutionSummary()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobExecutionSummaryForJob, T> g) {
        return obj -> g.apply((JobExecutionSummaryForJob)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String thingArn;
        private JobExecutionSummary jobExecutionSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(JobExecutionSummaryForJob model) {
            this.thingArn(model.thingArn);
            this.jobExecutionSummary(model.jobExecutionSummary);
        }

        public final String getThingArn() {
            return this.thingArn;
        }

        @Override
        public final Builder thingArn(String thingArn) {
            this.thingArn = thingArn;
            return this;
        }

        public final void setThingArn(String thingArn) {
            this.thingArn = thingArn;
        }

        public final JobExecutionSummary.Builder getJobExecutionSummary() {
            return this.jobExecutionSummary != null ? this.jobExecutionSummary.toBuilder() : null;
        }

        @Override
        public final Builder jobExecutionSummary(JobExecutionSummary jobExecutionSummary) {
            this.jobExecutionSummary = jobExecutionSummary;
            return this;
        }

        public final void setJobExecutionSummary(JobExecutionSummary.BuilderImpl jobExecutionSummary) {
            this.jobExecutionSummary = jobExecutionSummary != null ? jobExecutionSummary.build() : null;
        }

        public JobExecutionSummaryForJob build() {
            return new JobExecutionSummaryForJob(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JobExecutionSummaryForJob> {
        public Builder thingArn(String var1);

        public Builder jobExecutionSummary(JobExecutionSummary var1);

        default public Builder jobExecutionSummary(Consumer<JobExecutionSummary.Builder> jobExecutionSummary) {
            return this.jobExecutionSummary((JobExecutionSummary)((JobExecutionSummary.Builder)JobExecutionSummary.builder().applyMutation(jobExecutionSummary)).build());
        }
    }
}

