/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreatePolicyResponse
extends IotResponse
implements ToCopyableBuilder<Builder, CreatePolicyResponse> {
    private static final SdkField<String> POLICY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreatePolicyResponse.getter(CreatePolicyResponse::policyName)).setter(CreatePolicyResponse.setter(Builder::policyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyName").build()}).build();
    private static final SdkField<String> POLICY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreatePolicyResponse.getter(CreatePolicyResponse::policyArn)).setter(CreatePolicyResponse.setter(Builder::policyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyArn").build()}).build();
    private static final SdkField<String> POLICY_DOCUMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreatePolicyResponse.getter(CreatePolicyResponse::policyDocument)).setter(CreatePolicyResponse.setter(Builder::policyDocument)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyDocument").build()}).build();
    private static final SdkField<String> POLICY_VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreatePolicyResponse.getter(CreatePolicyResponse::policyVersionId)).setter(CreatePolicyResponse.setter(Builder::policyVersionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyVersionId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_NAME_FIELD, POLICY_ARN_FIELD, POLICY_DOCUMENT_FIELD, POLICY_VERSION_ID_FIELD));
    private final String policyName;
    private final String policyArn;
    private final String policyDocument;
    private final String policyVersionId;

    private CreatePolicyResponse(BuilderImpl builder) {
        super(builder);
        this.policyName = builder.policyName;
        this.policyArn = builder.policyArn;
        this.policyDocument = builder.policyDocument;
        this.policyVersionId = builder.policyVersionId;
    }

    public String policyName() {
        return this.policyName;
    }

    public String policyArn() {
        return this.policyArn;
    }

    public String policyDocument() {
        return this.policyDocument;
    }

    public String policyVersionId() {
        return this.policyVersionId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.policyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyDocument());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyVersionId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePolicyResponse)) {
            return false;
        }
        CreatePolicyResponse other = (CreatePolicyResponse)((Object)obj);
        return Objects.equals(this.policyName(), other.policyName()) && Objects.equals(this.policyArn(), other.policyArn()) && Objects.equals(this.policyDocument(), other.policyDocument()) && Objects.equals(this.policyVersionId(), other.policyVersionId());
    }

    public String toString() {
        return ToString.builder((String)"CreatePolicyResponse").add("PolicyName", (Object)this.policyName()).add("PolicyArn", (Object)this.policyArn()).add("PolicyDocument", (Object)this.policyDocument()).add("PolicyVersionId", (Object)this.policyVersionId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "policyName": {
                return Optional.ofNullable(clazz.cast(this.policyName()));
            }
            case "policyArn": {
                return Optional.ofNullable(clazz.cast(this.policyArn()));
            }
            case "policyDocument": {
                return Optional.ofNullable(clazz.cast(this.policyDocument()));
            }
            case "policyVersionId": {
                return Optional.ofNullable(clazz.cast(this.policyVersionId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreatePolicyResponse, T> g) {
        return obj -> g.apply((CreatePolicyResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private String policyName;
        private String policyArn;
        private String policyDocument;
        private String policyVersionId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePolicyResponse model) {
            super(model);
            this.policyName(model.policyName);
            this.policyArn(model.policyArn);
            this.policyDocument(model.policyDocument);
            this.policyVersionId(model.policyVersionId);
        }

        public final String getPolicyName() {
            return this.policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        public final String getPolicyArn() {
            return this.policyArn;
        }

        @Override
        public final Builder policyArn(String policyArn) {
            this.policyArn = policyArn;
            return this;
        }

        public final void setPolicyArn(String policyArn) {
            this.policyArn = policyArn;
        }

        public final String getPolicyDocument() {
            return this.policyDocument;
        }

        @Override
        public final Builder policyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
            return this;
        }

        public final void setPolicyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
        }

        public final String getPolicyVersionId() {
            return this.policyVersionId;
        }

        @Override
        public final Builder policyVersionId(String policyVersionId) {
            this.policyVersionId = policyVersionId;
            return this;
        }

        public final void setPolicyVersionId(String policyVersionId) {
            this.policyVersionId = policyVersionId;
        }

        @Override
        public CreatePolicyResponse build() {
            return new CreatePolicyResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreatePolicyResponse> {
        public Builder policyName(String var1);

        public Builder policyArn(String var1);

        public Builder policyDocument(String var1);

        public Builder policyVersionId(String var1);
    }
}

