/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.UserPropertiesCopier;
import software.amazon.awssdk.services.iot.model.UserProperty;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MqttHeaders
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MqttHeaders> {
    private static final SdkField<String> PAYLOAD_FORMAT_INDICATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("payloadFormatIndicator").getter(MqttHeaders.getter(MqttHeaders::payloadFormatIndicator)).setter(MqttHeaders.setter(Builder::payloadFormatIndicator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("payloadFormatIndicator").build()}).build();
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("contentType").getter(MqttHeaders.getter(MqttHeaders::contentType)).setter(MqttHeaders.setter(Builder::contentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentType").build()}).build();
    private static final SdkField<String> RESPONSE_TOPIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("responseTopic").getter(MqttHeaders.getter(MqttHeaders::responseTopic)).setter(MqttHeaders.setter(Builder::responseTopic)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responseTopic").build()}).build();
    private static final SdkField<String> CORRELATION_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("correlationData").getter(MqttHeaders.getter(MqttHeaders::correlationData)).setter(MqttHeaders.setter(Builder::correlationData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("correlationData").build()}).build();
    private static final SdkField<String> MESSAGE_EXPIRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("messageExpiry").getter(MqttHeaders.getter(MqttHeaders::messageExpiry)).setter(MqttHeaders.setter(Builder::messageExpiry)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messageExpiry").build()}).build();
    private static final SdkField<List<UserProperty>> USER_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("userProperties").getter(MqttHeaders.getter(MqttHeaders::userProperties)).setter(MqttHeaders.setter(Builder::userProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userProperties").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UserProperty::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PAYLOAD_FORMAT_INDICATOR_FIELD, CONTENT_TYPE_FIELD, RESPONSE_TOPIC_FIELD, CORRELATION_DATA_FIELD, MESSAGE_EXPIRY_FIELD, USER_PROPERTIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MqttHeaders.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String payloadFormatIndicator;
    private final String contentType;
    private final String responseTopic;
    private final String correlationData;
    private final String messageExpiry;
    private final List<UserProperty> userProperties;

    private MqttHeaders(BuilderImpl builder) {
        this.payloadFormatIndicator = builder.payloadFormatIndicator;
        this.contentType = builder.contentType;
        this.responseTopic = builder.responseTopic;
        this.correlationData = builder.correlationData;
        this.messageExpiry = builder.messageExpiry;
        this.userProperties = builder.userProperties;
    }

    public final String payloadFormatIndicator() {
        return this.payloadFormatIndicator;
    }

    public final String contentType() {
        return this.contentType;
    }

    public final String responseTopic() {
        return this.responseTopic;
    }

    public final String correlationData() {
        return this.correlationData;
    }

    public final String messageExpiry() {
        return this.messageExpiry;
    }

    public final boolean hasUserProperties() {
        return this.userProperties != null && !(this.userProperties instanceof SdkAutoConstructList);
    }

    public final List<UserProperty> userProperties() {
        return this.userProperties;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.payloadFormatIndicator());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentType());
        hashCode = 31 * hashCode + Objects.hashCode(this.responseTopic());
        hashCode = 31 * hashCode + Objects.hashCode(this.correlationData());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageExpiry());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserProperties() ? this.userProperties() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MqttHeaders)) {
            return false;
        }
        MqttHeaders other = (MqttHeaders)obj;
        return Objects.equals(this.payloadFormatIndicator(), other.payloadFormatIndicator()) && Objects.equals(this.contentType(), other.contentType()) && Objects.equals(this.responseTopic(), other.responseTopic()) && Objects.equals(this.correlationData(), other.correlationData()) && Objects.equals(this.messageExpiry(), other.messageExpiry()) && this.hasUserProperties() == other.hasUserProperties() && Objects.equals(this.userProperties(), other.userProperties());
    }

    public final String toString() {
        return ToString.builder((String)"MqttHeaders").add("PayloadFormatIndicator", (Object)this.payloadFormatIndicator()).add("ContentType", (Object)this.contentType()).add("ResponseTopic", (Object)this.responseTopic()).add("CorrelationData", (Object)this.correlationData()).add("MessageExpiry", (Object)this.messageExpiry()).add("UserProperties", this.hasUserProperties() ? this.userProperties() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "payloadFormatIndicator": {
                return Optional.ofNullable(clazz.cast(this.payloadFormatIndicator()));
            }
            case "contentType": {
                return Optional.ofNullable(clazz.cast(this.contentType()));
            }
            case "responseTopic": {
                return Optional.ofNullable(clazz.cast(this.responseTopic()));
            }
            case "correlationData": {
                return Optional.ofNullable(clazz.cast(this.correlationData()));
            }
            case "messageExpiry": {
                return Optional.ofNullable(clazz.cast(this.messageExpiry()));
            }
            case "userProperties": {
                return Optional.ofNullable(clazz.cast(this.userProperties()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("payloadFormatIndicator", PAYLOAD_FORMAT_INDICATOR_FIELD);
        map.put("contentType", CONTENT_TYPE_FIELD);
        map.put("responseTopic", RESPONSE_TOPIC_FIELD);
        map.put("correlationData", CORRELATION_DATA_FIELD);
        map.put("messageExpiry", MESSAGE_EXPIRY_FIELD);
        map.put("userProperties", USER_PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MqttHeaders, T> g) {
        return obj -> g.apply((MqttHeaders)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String payloadFormatIndicator;
        private String contentType;
        private String responseTopic;
        private String correlationData;
        private String messageExpiry;
        private List<UserProperty> userProperties = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MqttHeaders model) {
            this.payloadFormatIndicator(model.payloadFormatIndicator);
            this.contentType(model.contentType);
            this.responseTopic(model.responseTopic);
            this.correlationData(model.correlationData);
            this.messageExpiry(model.messageExpiry);
            this.userProperties(model.userProperties);
        }

        public final String getPayloadFormatIndicator() {
            return this.payloadFormatIndicator;
        }

        public final void setPayloadFormatIndicator(String payloadFormatIndicator) {
            this.payloadFormatIndicator = payloadFormatIndicator;
        }

        @Override
        public final Builder payloadFormatIndicator(String payloadFormatIndicator) {
            this.payloadFormatIndicator = payloadFormatIndicator;
            return this;
        }

        public final String getContentType() {
            return this.contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final String getResponseTopic() {
            return this.responseTopic;
        }

        public final void setResponseTopic(String responseTopic) {
            this.responseTopic = responseTopic;
        }

        @Override
        public final Builder responseTopic(String responseTopic) {
            this.responseTopic = responseTopic;
            return this;
        }

        public final String getCorrelationData() {
            return this.correlationData;
        }

        public final void setCorrelationData(String correlationData) {
            this.correlationData = correlationData;
        }

        @Override
        public final Builder correlationData(String correlationData) {
            this.correlationData = correlationData;
            return this;
        }

        public final String getMessageExpiry() {
            return this.messageExpiry;
        }

        public final void setMessageExpiry(String messageExpiry) {
            this.messageExpiry = messageExpiry;
        }

        @Override
        public final Builder messageExpiry(String messageExpiry) {
            this.messageExpiry = messageExpiry;
            return this;
        }

        public final List<UserProperty.Builder> getUserProperties() {
            List<UserProperty.Builder> result = UserPropertiesCopier.copyToBuilder(this.userProperties);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUserProperties(Collection<UserProperty.BuilderImpl> userProperties) {
            this.userProperties = UserPropertiesCopier.copyFromBuilder(userProperties);
        }

        @Override
        public final Builder userProperties(Collection<UserProperty> userProperties) {
            this.userProperties = UserPropertiesCopier.copy(userProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userProperties(UserProperty ... userProperties) {
            this.userProperties(Arrays.asList(userProperties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userProperties(Consumer<UserProperty.Builder> ... userProperties) {
            this.userProperties(Stream.of(userProperties).map(c -> (UserProperty)((UserProperty.Builder)UserProperty.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public MqttHeaders build() {
            return new MqttHeaders(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MqttHeaders> {
        public Builder payloadFormatIndicator(String var1);

        public Builder contentType(String var1);

        public Builder responseTopic(String var1);

        public Builder correlationData(String var1);

        public Builder messageExpiry(String var1);

        public Builder userProperties(Collection<UserProperty> var1);

        public Builder userProperties(UserProperty ... var1);

        public Builder userProperties(Consumer<UserProperty.Builder> ... var1);
    }
}

