/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssetPropertyVariant
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AssetPropertyVariant> {
    private static final SdkField<String> STRING_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stringValue").getter(AssetPropertyVariant.getter(AssetPropertyVariant::stringValue)).setter(AssetPropertyVariant.setter(Builder::stringValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stringValue").build()}).build();
    private static final SdkField<String> INTEGER_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("integerValue").getter(AssetPropertyVariant.getter(AssetPropertyVariant::integerValue)).setter(AssetPropertyVariant.setter(Builder::integerValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("integerValue").build()}).build();
    private static final SdkField<String> DOUBLE_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("doubleValue").getter(AssetPropertyVariant.getter(AssetPropertyVariant::doubleValue)).setter(AssetPropertyVariant.setter(Builder::doubleValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("doubleValue").build()}).build();
    private static final SdkField<String> BOOLEAN_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("booleanValue").getter(AssetPropertyVariant.getter(AssetPropertyVariant::booleanValue)).setter(AssetPropertyVariant.setter(Builder::booleanValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("booleanValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STRING_VALUE_FIELD, INTEGER_VALUE_FIELD, DOUBLE_VALUE_FIELD, BOOLEAN_VALUE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String stringValue;
    private final String integerValue;
    private final String doubleValue;
    private final String booleanValue;
    private final Type type;

    private AssetPropertyVariant(BuilderImpl builder) {
        this.stringValue = builder.stringValue;
        this.integerValue = builder.integerValue;
        this.doubleValue = builder.doubleValue;
        this.booleanValue = builder.booleanValue;
        this.type = builder.type;
    }

    public final String stringValue() {
        return this.stringValue;
    }

    public final String integerValue() {
        return this.integerValue;
    }

    public final String doubleValue() {
        return this.doubleValue;
    }

    public final String booleanValue() {
        return this.booleanValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stringValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.integerValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.doubleValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.booleanValue());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetPropertyVariant)) {
            return false;
        }
        AssetPropertyVariant other = (AssetPropertyVariant)obj;
        return Objects.equals(this.stringValue(), other.stringValue()) && Objects.equals(this.integerValue(), other.integerValue()) && Objects.equals(this.doubleValue(), other.doubleValue()) && Objects.equals(this.booleanValue(), other.booleanValue());
    }

    public final String toString() {
        return ToString.builder((String)"AssetPropertyVariant").add("StringValue", (Object)this.stringValue()).add("IntegerValue", (Object)this.integerValue()).add("DoubleValue", (Object)this.doubleValue()).add("BooleanValue", (Object)this.booleanValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "stringValue": {
                return Optional.ofNullable(clazz.cast(this.stringValue()));
            }
            case "integerValue": {
                return Optional.ofNullable(clazz.cast(this.integerValue()));
            }
            case "doubleValue": {
                return Optional.ofNullable(clazz.cast(this.doubleValue()));
            }
            case "booleanValue": {
                return Optional.ofNullable(clazz.cast(this.booleanValue()));
            }
        }
        return Optional.empty();
    }

    public static AssetPropertyVariant fromStringValue(String stringValue) {
        return (AssetPropertyVariant)AssetPropertyVariant.builder().stringValue(stringValue).build();
    }

    public static AssetPropertyVariant fromIntegerValue(String integerValue) {
        return (AssetPropertyVariant)AssetPropertyVariant.builder().integerValue(integerValue).build();
    }

    public static AssetPropertyVariant fromDoubleValue(String doubleValue) {
        return (AssetPropertyVariant)AssetPropertyVariant.builder().doubleValue(doubleValue).build();
    }

    public static AssetPropertyVariant fromBooleanValue(String booleanValue) {
        return (AssetPropertyVariant)AssetPropertyVariant.builder().booleanValue(booleanValue).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssetPropertyVariant, T> g) {
        return obj -> g.apply((AssetPropertyVariant)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        STRING_VALUE,
        INTEGER_VALUE,
        DOUBLE_VALUE,
        BOOLEAN_VALUE,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private String stringValue;
        private String integerValue;
        private String doubleValue;
        private String booleanValue;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(AssetPropertyVariant model) {
            this.stringValue(model.stringValue);
            this.integerValue(model.integerValue);
            this.doubleValue(model.doubleValue);
            this.booleanValue(model.booleanValue);
        }

        public final String getStringValue() {
            return this.stringValue;
        }

        public final void setStringValue(String stringValue) {
            String oldValue = this.stringValue;
            this.stringValue = stringValue;
            this.handleUnionValueChange(Type.STRING_VALUE, oldValue, this.stringValue);
        }

        @Override
        public final Builder stringValue(String stringValue) {
            String oldValue = this.stringValue;
            this.stringValue = stringValue;
            this.handleUnionValueChange(Type.STRING_VALUE, oldValue, this.stringValue);
            return this;
        }

        public final String getIntegerValue() {
            return this.integerValue;
        }

        public final void setIntegerValue(String integerValue) {
            String oldValue = this.integerValue;
            this.integerValue = integerValue;
            this.handleUnionValueChange(Type.INTEGER_VALUE, oldValue, this.integerValue);
        }

        @Override
        public final Builder integerValue(String integerValue) {
            String oldValue = this.integerValue;
            this.integerValue = integerValue;
            this.handleUnionValueChange(Type.INTEGER_VALUE, oldValue, this.integerValue);
            return this;
        }

        public final String getDoubleValue() {
            return this.doubleValue;
        }

        public final void setDoubleValue(String doubleValue) {
            String oldValue = this.doubleValue;
            this.doubleValue = doubleValue;
            this.handleUnionValueChange(Type.DOUBLE_VALUE, oldValue, this.doubleValue);
        }

        @Override
        public final Builder doubleValue(String doubleValue) {
            String oldValue = this.doubleValue;
            this.doubleValue = doubleValue;
            this.handleUnionValueChange(Type.DOUBLE_VALUE, oldValue, this.doubleValue);
            return this;
        }

        public final String getBooleanValue() {
            return this.booleanValue;
        }

        public final void setBooleanValue(String booleanValue) {
            String oldValue = this.booleanValue;
            this.booleanValue = booleanValue;
            this.handleUnionValueChange(Type.BOOLEAN_VALUE, oldValue, this.booleanValue);
        }

        @Override
        public final Builder booleanValue(String booleanValue) {
            String oldValue = this.booleanValue;
            this.booleanValue = booleanValue;
            this.handleUnionValueChange(Type.BOOLEAN_VALUE, oldValue, this.booleanValue);
            return this;
        }

        public AssetPropertyVariant build() {
            return new AssetPropertyVariant(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AssetPropertyVariant> {
        public Builder stringValue(String var1);

        public Builder integerValue(String var1);

        public Builder doubleValue(String var1);

        public Builder booleanValue(String var1);
    }
}

