/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotAsyncClient;
import software.amazon.awssdk.services.iot.internal.UserAgentUtils;
import software.amazon.awssdk.services.iot.model.ListProvisioningTemplateVersionsRequest;
import software.amazon.awssdk.services.iot.model.ListProvisioningTemplateVersionsResponse;
import software.amazon.awssdk.services.iot.model.ProvisioningTemplateVersionSummary;

public class ListProvisioningTemplateVersionsPublisher
implements SdkPublisher<ListProvisioningTemplateVersionsResponse> {
    private final IotAsyncClient client;
    private final ListProvisioningTemplateVersionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListProvisioningTemplateVersionsPublisher(IotAsyncClient client, ListProvisioningTemplateVersionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListProvisioningTemplateVersionsPublisher(IotAsyncClient client, ListProvisioningTemplateVersionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListProvisioningTemplateVersionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListProvisioningTemplateVersionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ProvisioningTemplateVersionSummary> versions() {
        Function<ListProvisioningTemplateVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.versions() != null) {
                return response.versions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListProvisioningTemplateVersionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListProvisioningTemplateVersionsResponseFetcher
    implements AsyncPageFetcher<ListProvisioningTemplateVersionsResponse> {
        private ListProvisioningTemplateVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListProvisioningTemplateVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListProvisioningTemplateVersionsResponse> nextPage(ListProvisioningTemplateVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListProvisioningTemplateVersionsPublisher.this.client.listProvisioningTemplateVersions(ListProvisioningTemplateVersionsPublisher.this.firstRequest);
            }
            return ListProvisioningTemplateVersionsPublisher.this.client.listProvisioningTemplateVersions((ListProvisioningTemplateVersionsRequest)((Object)ListProvisioningTemplateVersionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

