/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotAsyncClient;
import software.amazon.awssdk.services.iot.internal.UserAgentUtils;
import software.amazon.awssdk.services.iot.model.ListThingRegistrationTasksRequest;
import software.amazon.awssdk.services.iot.model.ListThingRegistrationTasksResponse;

public class ListThingRegistrationTasksPublisher
implements SdkPublisher<ListThingRegistrationTasksResponse> {
    private final IotAsyncClient client;
    private final ListThingRegistrationTasksRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListThingRegistrationTasksPublisher(IotAsyncClient client, ListThingRegistrationTasksRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListThingRegistrationTasksPublisher(IotAsyncClient client, ListThingRegistrationTasksRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListThingRegistrationTasksResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListThingRegistrationTasksResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> taskIds() {
        Function<ListThingRegistrationTasksResponse, Iterator> getIterator = response -> {
            if (response != null && response.taskIds() != null) {
                return response.taskIds().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListThingRegistrationTasksResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListThingRegistrationTasksResponseFetcher
    implements AsyncPageFetcher<ListThingRegistrationTasksResponse> {
        private ListThingRegistrationTasksResponseFetcher() {
        }

        public boolean hasNextPage(ListThingRegistrationTasksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListThingRegistrationTasksResponse> nextPage(ListThingRegistrationTasksResponse previousPage) {
            if (previousPage == null) {
                return ListThingRegistrationTasksPublisher.this.client.listThingRegistrationTasks(ListThingRegistrationTasksPublisher.this.firstRequest);
            }
            return ListThingRegistrationTasksPublisher.this.client.listThingRegistrationTasks((ListThingRegistrationTasksRequest)((Object)ListThingRegistrationTasksPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

