/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotClient;
import software.amazon.awssdk.services.iot.internal.UserAgentUtils;
import software.amazon.awssdk.services.iot.model.ListRoleAliasesRequest;
import software.amazon.awssdk.services.iot.model.ListRoleAliasesResponse;

public class ListRoleAliasesIterable
implements SdkIterable<ListRoleAliasesResponse> {
    private final IotClient client;
    private final ListRoleAliasesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRoleAliasesIterable(IotClient client, ListRoleAliasesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListRoleAliasesResponseFetcher();
    }

    public Iterator<ListRoleAliasesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> roleAliases() {
        Function<ListRoleAliasesResponse, Iterator> getIterator = response -> {
            if (response != null && response.roleAliases() != null) {
                return response.roleAliases().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListRoleAliasesResponseFetcher
    implements SyncPageFetcher<ListRoleAliasesResponse> {
        private ListRoleAliasesResponseFetcher() {
        }

        public boolean hasNextPage(ListRoleAliasesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextMarker());
        }

        public ListRoleAliasesResponse nextPage(ListRoleAliasesResponse previousPage) {
            if (previousPage == null) {
                return ListRoleAliasesIterable.this.client.listRoleAliases(ListRoleAliasesIterable.this.firstRequest);
            }
            return ListRoleAliasesIterable.this.client.listRoleAliases((ListRoleAliasesRequest)((Object)ListRoleAliasesIterable.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

