/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.IotRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeletePackageVersionRequest
extends IotRequest
implements ToCopyableBuilder<Builder, DeletePackageVersionRequest> {
    private static final SdkField<String> PACKAGE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("packageName").getter(DeletePackageVersionRequest.getter(DeletePackageVersionRequest::packageName)).setter(DeletePackageVersionRequest.setter(Builder::packageName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("packageName").build()}).build();
    private static final SdkField<String> VERSION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("versionName").getter(DeletePackageVersionRequest.getter(DeletePackageVersionRequest::versionName)).setter(DeletePackageVersionRequest.setter(Builder::versionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("versionName").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(DeletePackageVersionRequest.getter(DeletePackageVersionRequest::clientToken)).setter(DeletePackageVersionRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PACKAGE_NAME_FIELD, VERSION_NAME_FIELD, CLIENT_TOKEN_FIELD));
    private final String packageName;
    private final String versionName;
    private final String clientToken;

    private DeletePackageVersionRequest(BuilderImpl builder) {
        super(builder);
        this.packageName = builder.packageName;
        this.versionName = builder.versionName;
        this.clientToken = builder.clientToken;
    }

    public final String packageName() {
        return this.packageName;
    }

    public final String versionName() {
        return this.versionName;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.packageName());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeletePackageVersionRequest)) {
            return false;
        }
        DeletePackageVersionRequest other = (DeletePackageVersionRequest)((Object)obj);
        return Objects.equals(this.packageName(), other.packageName()) && Objects.equals(this.versionName(), other.versionName()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"DeletePackageVersionRequest").add("PackageName", (Object)this.packageName()).add("VersionName", (Object)this.versionName()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "packageName": {
                return Optional.ofNullable(clazz.cast(this.packageName()));
            }
            case "versionName": {
                return Optional.ofNullable(clazz.cast(this.versionName()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeletePackageVersionRequest, T> g) {
        return obj -> g.apply((DeletePackageVersionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotRequest.BuilderImpl
    implements Builder {
        private String packageName;
        private String versionName;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DeletePackageVersionRequest model) {
            super(model);
            this.packageName(model.packageName);
            this.versionName(model.versionName);
            this.clientToken(model.clientToken);
        }

        public final String getPackageName() {
            return this.packageName;
        }

        public final void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        @Override
        public final Builder packageName(String packageName) {
            this.packageName = packageName;
            return this;
        }

        public final String getVersionName() {
            return this.versionName;
        }

        public final void setVersionName(String versionName) {
            this.versionName = versionName;
        }

        @Override
        public final Builder versionName(String versionName) {
            this.versionName = versionName;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeletePackageVersionRequest build() {
            return new DeletePackageVersionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeletePackageVersionRequest> {
        public Builder packageName(String var1);

        public Builder versionName(String var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

