/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.services.iot.model.ValidationError;
import software.amazon.awssdk.services.iot.model.ValidationErrorsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ValidateSecurityProfileBehaviorsResponse
extends IotResponse
implements ToCopyableBuilder<Builder, ValidateSecurityProfileBehaviorsResponse> {
    private static final SdkField<Boolean> VALID_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("valid").getter(ValidateSecurityProfileBehaviorsResponse.getter(ValidateSecurityProfileBehaviorsResponse::valid)).setter(ValidateSecurityProfileBehaviorsResponse.setter(Builder::valid)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("valid").build()}).build();
    private static final SdkField<List<ValidationError>> VALIDATION_ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("validationErrors").getter(ValidateSecurityProfileBehaviorsResponse.getter(ValidateSecurityProfileBehaviorsResponse::validationErrors)).setter(ValidateSecurityProfileBehaviorsResponse.setter(Builder::validationErrors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validationErrors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ValidationError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALID_FIELD, VALIDATION_ERRORS_FIELD));
    private final Boolean valid;
    private final List<ValidationError> validationErrors;

    private ValidateSecurityProfileBehaviorsResponse(BuilderImpl builder) {
        super(builder);
        this.valid = builder.valid;
        this.validationErrors = builder.validationErrors;
    }

    public final Boolean valid() {
        return this.valid;
    }

    public final boolean hasValidationErrors() {
        return this.validationErrors != null && !(this.validationErrors instanceof SdkAutoConstructList);
    }

    public final List<ValidationError> validationErrors() {
        return this.validationErrors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.valid());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValidationErrors() ? this.validationErrors() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidateSecurityProfileBehaviorsResponse)) {
            return false;
        }
        ValidateSecurityProfileBehaviorsResponse other = (ValidateSecurityProfileBehaviorsResponse)((Object)obj);
        return Objects.equals(this.valid(), other.valid()) && this.hasValidationErrors() == other.hasValidationErrors() && Objects.equals(this.validationErrors(), other.validationErrors());
    }

    public final String toString() {
        return ToString.builder((String)"ValidateSecurityProfileBehaviorsResponse").add("Valid", (Object)this.valid()).add("ValidationErrors", this.hasValidationErrors() ? this.validationErrors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "valid": {
                return Optional.ofNullable(clazz.cast(this.valid()));
            }
            case "validationErrors": {
                return Optional.ofNullable(clazz.cast(this.validationErrors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ValidateSecurityProfileBehaviorsResponse, T> g) {
        return obj -> g.apply((ValidateSecurityProfileBehaviorsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private Boolean valid;
        private List<ValidationError> validationErrors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ValidateSecurityProfileBehaviorsResponse model) {
            super(model);
            this.valid(model.valid);
            this.validationErrors(model.validationErrors);
        }

        public final Boolean getValid() {
            return this.valid;
        }

        @Override
        public final Builder valid(Boolean valid) {
            this.valid = valid;
            return this;
        }

        public final void setValid(Boolean valid) {
            this.valid = valid;
        }

        public final List<ValidationError.Builder> getValidationErrors() {
            List<ValidationError.Builder> result = ValidationErrorsCopier.copyToBuilder(this.validationErrors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder validationErrors(Collection<ValidationError> validationErrors) {
            this.validationErrors = ValidationErrorsCopier.copy(validationErrors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validationErrors(ValidationError ... validationErrors) {
            this.validationErrors(Arrays.asList(validationErrors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validationErrors(Consumer<ValidationError.Builder> ... validationErrors) {
            this.validationErrors(Stream.of(validationErrors).map(c -> (ValidationError)((ValidationError.Builder)ValidationError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setValidationErrors(Collection<ValidationError.BuilderImpl> validationErrors) {
            this.validationErrors = ValidationErrorsCopier.copyFromBuilder(validationErrors);
        }

        @Override
        public ValidateSecurityProfileBehaviorsResponse build() {
            return new ValidateSecurityProfileBehaviorsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ValidateSecurityProfileBehaviorsResponse> {
        public Builder valid(Boolean var1);

        public Builder validationErrors(Collection<ValidationError> var1);

        public Builder validationErrors(ValidationError ... var1);

        public Builder validationErrors(Consumer<ValidationError.Builder> ... var1);
    }
}

