/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PresignedUrlConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PresignedUrlConfig> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(PresignedUrlConfig.getter(PresignedUrlConfig::roleArn)).setter(PresignedUrlConfig.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<Long> EXPIRES_IN_SEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("expiresInSec").getter(PresignedUrlConfig.getter(PresignedUrlConfig::expiresInSec)).setter(PresignedUrlConfig.setter(Builder::expiresInSec)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expiresInSec").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD, EXPIRES_IN_SEC_FIELD));
    private static final long serialVersionUID = 1L;
    private final String roleArn;
    private final Long expiresInSec;

    private PresignedUrlConfig(BuilderImpl builder) {
        this.roleArn = builder.roleArn;
        this.expiresInSec = builder.expiresInSec;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final Long expiresInSec() {
        return this.expiresInSec;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.expiresInSec());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PresignedUrlConfig)) {
            return false;
        }
        PresignedUrlConfig other = (PresignedUrlConfig)obj;
        return Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.expiresInSec(), other.expiresInSec());
    }

    public final String toString() {
        return ToString.builder((String)"PresignedUrlConfig").add("RoleArn", (Object)this.roleArn()).add("ExpiresInSec", (Object)this.expiresInSec()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "expiresInSec": {
                return Optional.ofNullable(clazz.cast(this.expiresInSec()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PresignedUrlConfig, T> g) {
        return obj -> g.apply((PresignedUrlConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String roleArn;
        private Long expiresInSec;

        private BuilderImpl() {
        }

        private BuilderImpl(PresignedUrlConfig model) {
            this.roleArn(model.roleArn);
            this.expiresInSec(model.expiresInSec);
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final Long getExpiresInSec() {
            return this.expiresInSec;
        }

        @Override
        public final Builder expiresInSec(Long expiresInSec) {
            this.expiresInSec = expiresInSec;
            return this;
        }

        public final void setExpiresInSec(Long expiresInSec) {
            this.expiresInSec = expiresInSec;
        }

        public PresignedUrlConfig build() {
            return new PresignedUrlConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PresignedUrlConfig> {
        public Builder roleArn(String var1);

        public Builder expiresInSec(Long var1);
    }
}

