/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.AuditMitigationActionExecutionMetadata;
import software.amazon.awssdk.services.iot.model.AuditMitigationActionExecutionMetadataListCopier;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAuditMitigationActionsExecutionsResponse
extends IotResponse
implements ToCopyableBuilder<Builder, ListAuditMitigationActionsExecutionsResponse> {
    private static final SdkField<List<AuditMitigationActionExecutionMetadata>> ACTIONS_EXECUTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("actionsExecutions").getter(ListAuditMitigationActionsExecutionsResponse.getter(ListAuditMitigationActionsExecutionsResponse::actionsExecutions)).setter(ListAuditMitigationActionsExecutionsResponse.setter(Builder::actionsExecutions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionsExecutions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AuditMitigationActionExecutionMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListAuditMitigationActionsExecutionsResponse.getter(ListAuditMitigationActionsExecutionsResponse::nextToken)).setter(ListAuditMitigationActionsExecutionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIONS_EXECUTIONS_FIELD, NEXT_TOKEN_FIELD));
    private final List<AuditMitigationActionExecutionMetadata> actionsExecutions;
    private final String nextToken;

    private ListAuditMitigationActionsExecutionsResponse(BuilderImpl builder) {
        super(builder);
        this.actionsExecutions = builder.actionsExecutions;
        this.nextToken = builder.nextToken;
    }

    public boolean hasActionsExecutions() {
        return this.actionsExecutions != null && !(this.actionsExecutions instanceof SdkAutoConstructList);
    }

    public List<AuditMitigationActionExecutionMetadata> actionsExecutions() {
        return this.actionsExecutions;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.actionsExecutions());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAuditMitigationActionsExecutionsResponse)) {
            return false;
        }
        ListAuditMitigationActionsExecutionsResponse other = (ListAuditMitigationActionsExecutionsResponse)((Object)obj);
        return Objects.equals(this.actionsExecutions(), other.actionsExecutions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListAuditMitigationActionsExecutionsResponse").add("ActionsExecutions", this.actionsExecutions()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "actionsExecutions": {
                return Optional.ofNullable(clazz.cast(this.actionsExecutions()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAuditMitigationActionsExecutionsResponse, T> g) {
        return obj -> g.apply((ListAuditMitigationActionsExecutionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private List<AuditMitigationActionExecutionMetadata> actionsExecutions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAuditMitigationActionsExecutionsResponse model) {
            super(model);
            this.actionsExecutions(model.actionsExecutions);
            this.nextToken(model.nextToken);
        }

        public final Collection<AuditMitigationActionExecutionMetadata.Builder> getActionsExecutions() {
            return this.actionsExecutions != null ? (Collection)this.actionsExecutions.stream().map(AuditMitigationActionExecutionMetadata::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder actionsExecutions(Collection<AuditMitigationActionExecutionMetadata> actionsExecutions) {
            this.actionsExecutions = AuditMitigationActionExecutionMetadataListCopier.copy(actionsExecutions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionsExecutions(AuditMitigationActionExecutionMetadata ... actionsExecutions) {
            this.actionsExecutions(Arrays.asList(actionsExecutions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionsExecutions(Consumer<AuditMitigationActionExecutionMetadata.Builder> ... actionsExecutions) {
            this.actionsExecutions(Stream.of(actionsExecutions).map(c -> (AuditMitigationActionExecutionMetadata)((AuditMitigationActionExecutionMetadata.Builder)AuditMitigationActionExecutionMetadata.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setActionsExecutions(Collection<AuditMitigationActionExecutionMetadata.BuilderImpl> actionsExecutions) {
            this.actionsExecutions = AuditMitigationActionExecutionMetadataListCopier.copyFromBuilder(actionsExecutions);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListAuditMitigationActionsExecutionsResponse build() {
            return new ListAuditMitigationActionsExecutionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAuditMitigationActionsExecutionsResponse> {
        public Builder actionsExecutions(Collection<AuditMitigationActionExecutionMetadata> var1);

        public Builder actionsExecutions(AuditMitigationActionExecutionMetadata ... var1);

        public Builder actionsExecutions(Consumer<AuditMitigationActionExecutionMetadata.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

